/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.appstore;

import gregtech.api.GTValues;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.ShaderTexture;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.widgets.AnimaWidgetGroup;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.interpolate.Eases;
import gregtech.api.util.interpolate.Interpolator;
import gregtech.client.shader.Shaders;
import gregtech.client.utils.RenderUtil;
import gregtech.common.items.behaviors.TerminalBehaviour;
import gregtech.common.terminal.app.appstore.AppPageWidget;
import gregtech.common.terminal.app.appstore.AppStoreApp;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AppCardWidget
extends AnimaWidgetGroup {
    private final AbstractApplication application;
    private final AppStoreApp store;
    @SideOnly(value=Side.CLIENT)
    private ImageWidget stateWidget;
    @SideOnly(value=Side.CLIENT)
    private ImageWidget bgWidget;
    @SideOnly(value=Side.CLIENT)
    private IGuiTexture banner;
    @SideOnly(value=Side.CLIENT)
    private int offset;
    @SideOnly(value=Side.CLIENT)
    private int alpha;

    public AppCardWidget(int x, int y, AbstractApplication application, AppStoreApp store) {
        super(x, y, 100, 100);
        this.application = application;
        this.store = store;
        TerminalOSWidget os = store.getOs();
        if (os.isRemote()) {
            this.addWidget(new CircleButtonWidget(15, 17).setColors(TerminalTheme.COLOR_B_2.getColor(), application.getThemeColor(), TerminalTheme.COLOR_B_2.getColor()).setHoverText(application.getUnlocalizedName()).setIcon(application.getIcon()));
            this.addWidget(new ImageWidget(30, 0, 65, 34, new TextTexture(application.getUnlocalizedName(), -1).setDropShadow(true).setWidth(65)));
            this.offset = Math.abs(GTValues.RNG.nextInt()) % 200;
            this.banner = application.getBanner();
            if (os.installedApps.contains(application)) {
                if (TerminalBehaviour.isCreative(os.itemStack) || application.getMaxTier() == Math.min(os.tabletNBT.func_74775_l(application.getRegistryName()).func_74762_e("_tier"), application.getMaxTier())) {
                    this.updateState(0);
                } else {
                    this.updateState(1);
                }
            } else {
                this.updateState(2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateState(int state) {
        String text = "Latest";
        int bg = -11842484;
        if (state == 1) {
            text = "Upgrade";
            bg = -552673;
        } else if (state == 2) {
            text = "Install";
            bg = -9963701;
        }
        if (this.stateWidget != null) {
            this.removeWidget(this.stateWidget);
            this.removeWidget(this.bgWidget);
        }
        this.stateWidget = new ImageWidget(15, 85, 70, 15, new TextTexture(text, -1).setWidth(70).setDropShadow(true).setType(TextTexture.TextType.HIDE));
        this.bgWidget = new ImageWidget(15, 85, 70, 13, new ColorRectTexture(bg));
        this.addWidget(this.bgWidget);
        this.addWidget(this.stateWidget);
    }

    private void openDialog() {
        new AppPageWidget(this.application, this.store, this).open();
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == -1) {
            if (buffer.readBoolean()) {
                this.openDialog();
            }
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.writeClientAction(-1, buffer -> buffer.writeBoolean(true));
            this.openDialog();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void hookDrawInForeground(int mouseX, int mouseY) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.isMouseOverElement(mouseX, mouseY) && this.store.getOs().desktop.widgets.stream().noneMatch(app -> app instanceof TerminalDialogWidget)) {
            int dur = 7;
            int maxAlpha = 100;
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            if (this.alpha != maxAlpha && this.interpolator == null) {
                this.interpolator = new Interpolator(0.0f, maxAlpha, dur, Eases.EaseLinear, value -> {
                    this.alpha = value.intValue();
                }, value -> {
                    this.interpolator = null;
                });
                this.interpolator.start();
            }
            int color = this.alpha == maxAlpha ? TerminalTheme.COLOR_B_2.getColor() & 0xFFFFFF | this.alpha << 24 : TerminalTheme.COLOR_B_2.getColor() & 0xFFFFFF | this.alpha + (int)((float)maxAlpha * partialTicks / (float)dur) << 24;
            int finalColor = color;
            RenderUtil.useScissor(this.store.getPosition().x, this.store.getPosition().y, this.store.getSize().width, this.store.getSize().height, () -> {
                AppCardWidget.drawSolidRect(0, 0, this.gui.getScreenWidth(), y, finalColor);
                AppCardWidget.drawSolidRect(0, y + height, this.gui.getScreenWidth(), this.gui.getScreenHeight(), finalColor);
                AppCardWidget.drawSolidRect(0, y, x, height, finalColor);
                AppCardWidget.drawSolidRect(x + width, y, this.gui.getScreenWidth(), height, finalColor);
                AppCardWidget.drawBorder(x, y, width, height, this.application.getThemeColor(), -1);
            });
        } else {
            this.alpha = 0;
        }
        super.hookDrawInForeground(mouseX, mouseY);
    }

    @Override
    public void hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        Color color = new Color(this.application.getThemeColor());
        AppCardWidget.drawSolidRect(x, y, width, height, color.getRGB() & 0xFFFFFF | 0x4F000000);
        if (this.banner != null) {
            this.banner.draw(x, y, width, 34);
        } else if (Shaders.allowedShader()) {
            float time = (float)this.offset + ((float)this.gui.entityPlayer.field_70173_aa + partialTicks) / 20.0f;
            ShaderTexture.createShader("banner.frag").draw(x, y, width, 34, uniformCache -> {
                uniformCache.glUniform1F("u_time", time);
                uniformCache.glUniform3F("b_color", (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            });
        } else {
            AppCardWidget.drawSolidRect(x, y, width, 34, color.getRGB());
        }
        super.hookDrawInBackground(mouseX, mouseY, partialTicks, context);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        List description = fr.func_78271_c(this.application.getDescription(), 90);
        int fColor = this.store.darkMode ? -1 : -13421773;
        for (int i = 0; i < Math.min(description.size(), 4); ++i) {
            fr.func_175065_a((String)description.get(i), (float)(x + 5), (float)(y + 40 + i * fr.field_78288_b), fColor, this.store.darkMode);
        }
        if (description.size() > 4) {
            fr.func_175065_a("...", (float)(x + 5), (float)(y + 40 + 4 * fr.field_78288_b), fColor, this.store.darkMode);
        }
        AppCardWidget.drawGradientRect(x, y + 34, width, 3.0f, 0x6F000000, 0, false);
        AppCardWidget.drawRectShadow(x, y, width, height, 5);
    }
}

