/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.batterymanager;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.ShaderTexture;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.client.shader.Shaders;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BatteryWidget
extends Widget {
    @SideOnly(value=Side.CLIENT)
    private ShaderTexture battery;
    private final TerminalOSWidget os;

    public BatteryWidget(int x, int y, int width, int height, TerminalOSWidget os) {
        super(x, y, width, height);
        this.os = os;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        float left = 0.0f;
        IElectricItem electricItem = this.os.hardwareProvider.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem != null) {
            left = (float)electricItem.getCharge() / (float)electricItem.getMaxCharge();
        }
        if (Shaders.allowedShader()) {
            float progress = left;
            float time = ((float)this.gui.entityPlayer.field_70173_aa + partialTicks) / 20.0f;
            int color = TerminalTheme.COLOR_F_1.getColor();
            if (this.battery == null) {
                this.battery = ShaderTexture.createShader("battery.frag");
            }
            this.battery.draw(x, y, width, height, uniformCache -> {
                uniformCache.glUniform1F("u_time", time);
                uniformCache.glUniform1F("progress", progress);
                uniformCache.glUniform3F("c_ring", 0.55f, 0.7f, 0.7f);
                uniformCache.glUniform3F("c_sector", (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
                uniformCache.glUniform3F("c_water", 1.0f * (1.0f - progress), progress, 0.0f);
            });
        } else {
            int b_color = (int)(255.0f * (1.0f - left)) << 16 | (int)(255.0f * left) << 8 | 0xFF000000;
            BatteryWidget.drawBorder(x, y, width, height, TerminalTheme.COLOR_1.getColor(), 2);
            BatteryWidget.drawSolidRect(x, y + height - (int)((float)height * left), width, (int)((float)height * left), b_color);
        }
        BatteryWidget.drawStringSized(String.format("%.2f%%", Float.valueOf(left * 100.0f)), (float)x + (float)width / 2.0f + 3.0f, (float)y + (float)height / 2.0f - 7.0f, -1, true, 2.0f, true);
    }
}

