/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.console;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.RecipeLogicSteam;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.ItemStackTexture;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.Size;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMaintenanceHatch;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumChest;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumTank;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.lwjgl.opengl.GL11;

public class MachineConsoleWidget
extends WidgetGroup {
    private BlockPos pos;
    private EnumFacing facing;
    private MetaTileEntity mte;
    private UIWidgetGroup uiWidgetGroup;

    public MachineConsoleWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void setFocus(BlockPos pos, EnumFacing facing) {
        this.pos = new BlockPos((Vec3i)pos);
        this.facing = facing;
        this.mte = null;
        this.checkMachine();
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.checkMachine();
    }

    private void checkMachine() {
        if (this.mte != null && this.mte.isValid()) {
            return;
        }
        if (this.pos != null && this.facing != null) {
            TileEntity te = this.gui.entityPlayer.field_70170_p.func_175625_s(this.pos);
            this.clearAllWidgets();
            if (te instanceof IGregTechTileEntity && ((IGregTechTileEntity)te).isValid()) {
                this.mte = ((IGregTechTileEntity)te).getMetaTileEntity();
                this.initWidgets();
                if (this.isRemote()) {
                    this.writeClientAction(5, buf -> {
                        buf.func_179255_a(this.pos);
                        buf.writeByte(this.facing.func_176745_a());
                    });
                }
            }
        }
    }

    private void initWidgets() {
        if (this.mte != null) {
            CoverBehavior cover;
            IControllable controllable;
            this.uiWidgetGroup = new UIWidgetGroup();
            this.uiWidgetGroup.setActive(false);
            this.uiWidgetGroup.setVisible(false);
            Size size = this.getSize();
            this.addWidget(new ImageWidget(0, 0, size.width, size.height, GuiTextures.BACKGROUND));
            this.addWidget(new SimpleTextWidget(size.width / 2, 12, "", -1, () -> this.facing.toString().toUpperCase()).setShadow(true));
            int y = 20;
            if (this.mte.hasFrontFacing()) {
                this.addWidget(new RectButtonWidget(10, y, size.width - 20, 20, 1).setClickListener(clickData -> {
                    if (!this.isRemote() && this.mte.isValidFrontFacing(this.facing)) {
                        this.mte.setFrontFacing(this.facing);
                    }
                }).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setIcon(new TextTexture("terminal.console.front", -1)));
                y += 25;
            }
            if ((controllable = this.mte.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, this.facing)) != null) {
                this.addWidget(new RectButtonWidget(10, y, 20, 20, 1).setToggleButton((IGuiTexture)GuiTextures.BUTTON_WORKING_ENABLE.getSubArea(0.0, 0.0, 1.0, 0.5), (c, p) -> {
                    if (!this.isRemote()) {
                        controllable.setWorkingEnabled((boolean)p);
                    }
                }).setValueSupplier(false, controllable::isWorkingEnabled).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), 0).setHoverText("terminal.console.controllable").setIcon(GuiTextures.BUTTON_WORKING_ENABLE.getSubArea(0.0, 0.5, 1.0, 0.5)));
                AbstractRecipeLogic recipeLogic = this.mte.getCapability(GregtechTileCapabilities.CAPABILITY_RECIPE_LOGIC, this.facing);
                if (recipeLogic != null) {
                    this.addWidget(new CycleButtonWidget(35, y, 20, 20, recipeLogic.getAvailableOverclockingTiers(), recipeLogic::getOverclockTier, recipeLogic::setOverclockTier).setTooltipHoverString("gregtech.gui.overclock.description").setButtonTexture(GuiTextures.BUTTON_OVERCLOCK));
                    this.addWidget(new ProgressWidget(recipeLogic::getProgressPercent, 60, y, 63, 20, GuiTextures.PROGRESS_BAR_ARC_FURNACE, ProgressWidget.MoveType.HORIZONTAL));
                    if (recipeLogic instanceof RecipeLogicSteam) {
                        this.addWidget(new RectButtonWidget(10, y += 25, size.width - 20, 20, 1).setClickListener(clickData -> {
                            EnumFacing currentVentingSide = ((RecipeLogicSteam)recipeLogic).getVentingSide();
                            if (currentVentingSide == this.facing || this.mte.getFrontFacing() == this.facing) {
                                return;
                            }
                            ((RecipeLogicSteam)recipeLogic).setVentingSide(this.facing);
                        }).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setIcon(new TextTexture("terminal.console.venting", -1)));
                    }
                }
                y += 25;
            }
            if (this.mte instanceof SimpleMachineMetaTileEntity) {
                SimpleMachineMetaTileEntity simpleMTE = (SimpleMachineMetaTileEntity)this.mte;
                if (simpleMTE.getExportItems().getSlots() > 0) {
                    this.addWidget(new ImageWidget(10, y, 20, 20, new ItemStackTexture(Items.field_151114_aO, new Item[0])));
                    this.addWidget(new RectButtonWidget(33, y, 50, 20, 1).setClickListener(clickData -> {
                        if (!this.isRemote() && this.mte.getFrontFacing() != this.facing) {
                            simpleMTE.setOutputFacingItems(this.facing);
                        }
                    }).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setHoverText("terminal.console.items"));
                    this.addWidget(new SimpleTextWidget(58, y + 10, "", -1, () -> simpleMTE.getOutputFacingItems().toString()));
                    this.addWidget(new RectButtonWidget(83, y, 20, 20, 1).setToggleButton((IGuiTexture)GuiTextures.BUTTON_ITEM_OUTPUT.getSubArea(0.0, 0.5, 1.0, 0.5), (c, p) -> {
                        if (!this.isRemote()) {
                            simpleMTE.setAutoOutputItems((boolean)p);
                        }
                    }).setInitValue(simpleMTE.isAutoOutputItems()).setValueSupplier(false, simpleMTE::isAutoOutputItems).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), 0).setHoverText("terminal.console.auto_output").setIcon(GuiTextures.BUTTON_ITEM_OUTPUT.getSubArea(0.0, 0.0, 1.0, 0.5)));
                    this.addWidget(new RectButtonWidget(103, y, 20, 20, 1).setToggleButton((IGuiTexture)GuiTextures.BUTTON_ALLOW_IMPORT_EXPORT.getSubArea(0.0, 0.5, 1.0, 0.5), (c, p) -> {
                        if (!this.isRemote()) {
                            simpleMTE.setAllowInputFromOutputSideItems((boolean)p);
                        }
                    }).setInitValue(simpleMTE.isAllowInputFromOutputSideItems()).setValueSupplier(false, simpleMTE::isAllowInputFromOutputSideItems).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), 0).setHoverText("terminal.console.input").setIcon(GuiTextures.BUTTON_ALLOW_IMPORT_EXPORT.getSubArea(0.0, 0.0, 1.0, 0.5)));
                    y += 20;
                }
                if (simpleMTE.getExportFluids().getTanks() > 0) {
                    this.addWidget(new ImageWidget(10, y, 20, 20, new ItemStackTexture(Items.field_151131_as, new Item[0])));
                    this.addWidget(new RectButtonWidget(33, y, 50, 20, 1).setClickListener(clickData -> {
                        if (!this.isRemote() && simpleMTE.getFrontFacing() != this.facing) {
                            simpleMTE.setOutputFacingFluids(this.facing);
                        }
                    }).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setHoverText("terminal.console.fluids"));
                    this.addWidget(new SimpleTextWidget(58, y + 10, "", -1, () -> simpleMTE.getOutputFacingFluids().toString()));
                    this.addWidget(new RectButtonWidget(83, y, 20, 20, 1).setToggleButton((IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT.getSubArea(0.0, 0.5, 1.0, 0.5), (c, p) -> {
                        if (!this.isRemote()) {
                            simpleMTE.setAutoOutputFluids((boolean)p);
                        }
                    }).setInitValue(simpleMTE.isAutoOutputFluids()).setValueSupplier(false, simpleMTE::isAutoOutputFluids).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), 0).setHoverText("terminal.console.auto_output").setIcon(GuiTextures.BUTTON_FLUID_OUTPUT.getSubArea(0.0, 0.0, 1.0, 0.5)));
                    this.addWidget(new RectButtonWidget(103, y, 20, 20, 1).setToggleButton((IGuiTexture)GuiTextures.BUTTON_ALLOW_IMPORT_EXPORT.getSubArea(0.0, 0.5, 1.0, 0.5), (c, p) -> {
                        if (!this.isRemote()) {
                            simpleMTE.setAllowInputFromOutputSideFluids((boolean)p);
                        }
                    }).setInitValue(simpleMTE.isAllowInputFromOutputSideFluids()).setValueSupplier(false, simpleMTE::isAllowInputFromOutputSideFluids).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), 0).setHoverText("terminal.console.input").setIcon(GuiTextures.BUTTON_ALLOW_IMPORT_EXPORT.getSubArea(0.0, 0.0, 1.0, 0.5)));
                    y += 20;
                }
                y += 5;
            }
            if (this.mte instanceof MetaTileEntityQuantumChest) {
                MetaTileEntityQuantumChest chest = (MetaTileEntityQuantumChest)this.mte;
                this.addWidget(new ImageWidget(10, y, 20, 20, new ItemStackTexture(Items.field_151114_aO, new Item[0])));
                this.addWidget(new RectButtonWidget(33, y, 50, 20, 1).setClickListener(clickData -> {
                    if (!this.isRemote() && this.mte.getFrontFacing() != this.facing) {
                        chest.setOutputFacing(this.facing);
                    }
                }).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setHoverText("terminal.console.items"));
                this.addWidget(new SimpleTextWidget(58, y + 10, "", -1, () -> chest.getOutputFacing().toString()));
                this.addWidget(new RectButtonWidget(83, y, 20, 20, 1).setToggleButton((IGuiTexture)GuiTextures.BUTTON_ITEM_OUTPUT.getSubArea(0.0, 0.5, 1.0, 0.5), (c, p) -> {
                    if (!this.isRemote()) {
                        chest.setAutoOutputItems((boolean)p);
                    }
                }).setInitValue(chest.isAutoOutputItems()).setValueSupplier(false, chest::isAutoOutputItems).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), 0).setHoverText("terminal.console.auto_output").setIcon(GuiTextures.BUTTON_ITEM_OUTPUT.getSubArea(0.0, 0.0, 1.0, 0.5)));
                this.addWidget(new RectButtonWidget(103, y, 20, 20, 1).setToggleButton((IGuiTexture)GuiTextures.BUTTON_ALLOW_IMPORT_EXPORT.getSubArea(0.0, 0.5, 1.0, 0.5), (c, p) -> {
                    if (!this.isRemote()) {
                        chest.setAllowInputFromOutputSide((boolean)p);
                    }
                }).setInitValue(chest.isAllowInputFromOutputSideItems()).setValueSupplier(false, chest::isAllowInputFromOutputSideItems).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), 0).setHoverText("terminal.console.input").setIcon(GuiTextures.BUTTON_ALLOW_IMPORT_EXPORT.getSubArea(0.0, 0.0, 1.0, 0.5)));
                y += 25;
            } else if (this.mte instanceof MetaTileEntityQuantumTank) {
                MetaTileEntityQuantumTank tank = (MetaTileEntityQuantumTank)this.mte;
                this.addWidget(new ImageWidget(10, y, 20, 20, new ItemStackTexture(Items.field_151131_as, new Item[0])));
                this.addWidget(new RectButtonWidget(33, y, 50, 20, 1).setClickListener(clickData -> {
                    if (!this.isRemote() && tank.getFrontFacing() != this.facing) {
                        tank.setOutputFacing(this.facing);
                    }
                }).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setHoverText("terminal.console.fluids"));
                this.addWidget(new SimpleTextWidget(58, y + 10, "", -1, () -> tank.getOutputFacing().toString()));
                this.addWidget(new RectButtonWidget(83, y, 20, 20, 1).setToggleButton((IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT.getSubArea(0.0, 0.5, 1.0, 0.5), (c, p) -> {
                    if (!this.isRemote()) {
                        tank.setAutoOutputFluids((boolean)p);
                    }
                }).setInitValue(tank.isAutoOutputFluids()).setValueSupplier(false, tank::isAutoOutputFluids).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), 0).setHoverText("terminal.console.auto_output").setIcon(GuiTextures.BUTTON_FLUID_OUTPUT.getSubArea(0.0, 0.0, 1.0, 0.5)));
                this.addWidget(new RectButtonWidget(103, y, 20, 20, 1).setToggleButton((IGuiTexture)GuiTextures.BUTTON_ALLOW_IMPORT_EXPORT.getSubArea(0.0, 0.5, 1.0, 0.5), (c, p) -> {
                    if (!this.isRemote()) {
                        tank.setAllowInputFromOutputSide((boolean)p);
                    }
                }).setInitValue(tank.isAllowInputFromOutputSideFluids()).setValueSupplier(false, tank::isAllowInputFromOutputSideFluids).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), 0).setHoverText("terminal.console.input").setIcon(GuiTextures.BUTTON_ALLOW_IMPORT_EXPORT.getSubArea(0.0, 0.0, 1.0, 0.5)));
                y += 25;
            }
            if (this.mte instanceof MetaTileEntityMultiblockPart && this.mte instanceof MetaTileEntityMaintenanceHatch) {
                this.addWidget(new RectButtonWidget(10, y, size.width - 20, 20, 1).setClickListener(clickData -> {
                    if (!this.isRemote()) {
                        ((MetaTileEntityMaintenanceHatch)this.mte).fixAllMaintenanceProblems();
                    }
                }).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setIcon(new TextTexture("terminal.console.maintenance", -1)));
                y += 25;
            }
            if ((cover = this.mte.getCoverAtSide(this.facing)) != null) {
                this.addWidget(new SlotWidget((IItemHandler)new ItemStackHandler(NonNullList.func_191197_a((int)1, (Object)cover.getPickItem())), 0, 10, y, false, false));
                this.addWidget(new SimpleTextWidget(58, y + 10, "terminal.console.cover_rs", -1, () -> String.valueOf(cover.getRedstoneSignalOutput())).setShadow(true).setCenter(true));
                if (cover instanceof CoverWithUI) {
                    this.addWidget(new RectButtonWidget(83, y, 40, 20, 1).setClickListener(clickData -> this.uiWidgetGroup.openUI(((CoverWithUI)((Object)cover)).createUI(this.gui.entityPlayer))).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setIcon(new TextTexture("terminal.console.cover_gui", -1)));
                }
                y += 25;
            }
            this.addWidget(new RectButtonWidget(10, y, size.width - 20, 20, 1).setClickListener(clickData -> this.uiWidgetGroup.openUI(this.mte.getModularUI(this.gui.entityPlayer))).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_B_2.getColor()).setIcon(new TextTexture("terminal.console.gui", -1)));
            this.addWidget(this.uiWidgetGroup);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 5) {
            this.setFocus(buffer.func_179259_c(), EnumFacing.field_82609_l[buffer.readByte()]);
        } else {
            super.handleClientAction(id, buffer);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.uiWidgetGroup != null && this.uiWidgetGroup.isVisible()) {
            return;
        }
        super.drawInForeground(mouseX, mouseY);
    }

    private static class UIWidgetGroup
    extends WidgetGroup {
        private IGuiTexture background;

        private UIWidgetGroup() {
        }

        public void clearUI() {
            this.background = null;
            this.clearAllWidgets();
            this.setActive(false);
            this.setVisible(false);
        }

        public void openUI(ModularUI ui) {
            this.clearUI();
            if (ui != null) {
                this.background = ui.backgroundPath;
                for (Widget widget : ui.guiWidgets.values()) {
                    SlotWidget slotWidget;
                    if (widget instanceof SlotWidget && (slotWidget = (SlotWidget)widget).getHandle().func_75211_c() == this.gui.entityPlayer.func_184586_b(EnumHand.MAIN_HAND)) {
                        slotWidget.setActive(false);
                    }
                    this.addWidget(widget);
                }
                this.setSize(new Size(ui.getWidth(), ui.getHeight()));
                this.addSelfPosition(this.gui.getScreenWidth() / 2 - this.getPosition().x - ui.getWidth() / 2, this.gui.getScreenHeight() / 2 - this.getPosition().y - ui.getHeight() / 2);
                this.setActive(true);
                this.setVisible(true);
            }
        }

        @Override
        public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
            UIWidgetGroup.drawSolidRect(0, 0, this.gui.getScreenWidth(), this.gui.getScreenHeight(), -1090519040);
            if (this.background != null) {
                this.background.draw(this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height);
            }
            GL11.glDisable((int)3089);
            GlStateManager.func_179097_i();
            super.drawInBackground(mouseX, mouseY, partialTicks, context);
            GlStateManager.func_179126_j();
            GL11.glEnable((int)3089);
        }

        @Override
        public boolean keyTyped(char charTyped, int keyCode) {
            if (keyCode == 1) {
                this.clearUI();
                this.writeClientAction(5, buffer -> buffer.writeBoolean(true));
                return true;
            }
            super.keyTyped(charTyped, keyCode);
            return true;
        }

        @Override
        public void handleClientAction(int id, PacketBuffer buffer) {
            if (id == 5) {
                if (buffer.readBoolean()) {
                    this.clearUI();
                }
            } else {
                super.handleClientAction(id, buffer);
            }
        }

        @Override
        public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
            super.mouseWheelMove(mouseX, mouseY, wheelDelta);
            return true;
        }

        @Override
        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            super.mouseClicked(mouseX, mouseY, button);
            return true;
        }

        @Override
        public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
            super.mouseDragged(mouseX, mouseY, button, timeDragged);
            return true;
        }

        @Override
        public boolean mouseReleased(int mouseX, int mouseY, int button) {
            super.mouseReleased(mouseX, mouseY, button);
            return true;
        }
    }
}

