/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guide;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.widgets.TreeListWidget;
import gregtech.api.terminal.os.menu.IMenuComponent;
import gregtech.api.terminal.util.TreeNode;
import gregtech.api.util.FileUtility;
import gregtech.api.util.GTLog;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.terminal.app.guide.widget.GuidePageWidget;
import gregtech.common.terminal.component.SearchComponent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class GuideApp<T>
extends AbstractApplication
implements SearchComponent.IWidgetSearch<Stack<TreeNode<String, T>>> {
    private GuidePageWidget pageWidget;
    private TreeListWidget<String, T> tree;
    private TreeNode<String, T> ROOT;
    private Map<T, JsonObject> jsonObjectMap;
    private final IGuiTexture icon;
    private float scale = 1.0f;

    public GuideApp(String name, IGuiTexture icon) {
        super(name);
        this.icon = icon;
    }

    @Override
    public IGuiTexture getIcon() {
        return this.icon;
    }

    @Override
    public AbstractApplication initApp() {
        if (this.isClient) {
            this.ROOT = new TreeNode(0, "root");
            this.jsonObjectMap = new HashMap<T, JsonObject>();
            this.loadJsonFiles();
            this.buildTree();
        }
        return this;
    }

    protected void loadPage(TreeNode<String, T> leaf) {
        JsonObject page;
        if (leaf == null) {
            return;
        }
        if (this.pageWidget != null) {
            this.removeWidget(this.pageWidget);
        }
        this.pageWidget = new GuidePageWidget(this.getOs().getSize().width - 200, 0, 200, this.getOs().getSize().height, 5);
        if (leaf.isLeaf() && leaf.getContent() != null && (page = this.jsonObjectMap.get(leaf.getContent())) != null) {
            this.pageWidget.loadJsonConfig(page);
        }
        this.addWidget(this.pageWidget);
        this.onOSSizeUpdate(this.getOs().getSize().width, this.getOs().getSize().height);
    }

    @Override
    public boolean isClientSideApp() {
        return true;
    }

    protected IGuiTexture itemIcon(T item) {
        return null;
    }

    protected abstract String itemName(T var1);

    protected abstract String rawItemName(T var1);

    protected final TreeNode<String, T> getTree() {
        return this.ROOT;
    }

    public final void loadJsonFiles() {
        ArrayList jsons = new ArrayList();
        String lang = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        try {
            Path guidePath = TerminalRegistry.TERMINAL_PATH.toPath().resolve("guide/" + this.getRegistryName());
            Path en_us = guidePath.resolve("en_us");
            Files.walk(en_us, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.toString().endsWith(".json")).forEach(file -> {
                File langFile = guidePath.resolve(lang + "/" + en_us.relativize((Path)file).toString()).toFile();
                JsonObject json = this.getConfig(langFile);
                if (json == null) {
                    json = this.getConfig(file.toFile());
                }
                if (json != null) {
                    jsons.add(json);
                }
            });
        }
        catch (IOException e) {
            GTLog.logger.error("Failed to load file on path {}", (Object)"terminal", (Object)e);
        }
        this.ROOT = new TreeNode(0, "root");
        this.jsonObjectMap = new HashMap<T, JsonObject>();
        for (JsonObject json : jsons) {
            T t = this.ofJson(json);
            if (t == null) continue;
            this.registerItem(t, json.get("section").getAsString());
            this.jsonObjectMap.put(t, json);
        }
    }

    public abstract T ofJson(JsonObject var1);

    private JsonObject getConfig(File file) {
        JsonElement je = FileUtility.loadJson(file);
        return je == null ? null : (je.isJsonObject() ? je.getAsJsonObject() : null);
    }

    @Override
    public boolean isManualInterrupt() {
        return true;
    }

    @Override
    public void search(String word, Consumer<Stack<TreeNode<String, T>>> find) {
        Stack<TreeNode<String, T>> stack = new Stack<TreeNode<String, T>>();
        if (this.getTree() != null) {
            stack.push(this.getTree());
            this.dfsSearch(Thread.currentThread(), stack, word.toLowerCase(), find);
        }
    }

    private boolean dfsSearch(Thread thread, Stack<TreeNode<String, T>> stack, String regex, Consumer<Stack<TreeNode<String, T>>> find) {
        if (thread.isInterrupted()) {
            return true;
        }
        TreeNode<String, T> node = stack.peek();
        if (!node.isLeaf() && I18n.func_135052_a((String)node.getKey(), (Object[])new Object[0]).toLowerCase().contains(regex)) {
            find.accept((Stack)stack.clone());
        } else if (node.isLeaf()) {
            String name = this.itemName(node.getContent());
            if (name == null) {
                name = node.getKey();
            }
            if (I18n.func_135052_a((String)name, (Object[])new Object[0]).toLowerCase().contains(regex)) {
                find.accept((Stack)stack.clone());
            }
        }
        if (node.getChildren() != null) {
            for (TreeNode<String, T> child : node.getChildren()) {
                stack.push(child);
                if (this.dfsSearch(thread, stack, regex, find)) {
                    return true;
                }
                stack.pop();
            }
        }
        return false;
    }

    protected void registerItem(T item, String path) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            String[] parts = path.split("/");
            TreeNode<String, String> child = this.ROOT;
            if (!parts[0].isEmpty()) {
                for (String sub : parts) {
                    child = child.getOrCreateChild(sub);
                }
            }
            child.addContent(this.rawItemName(item), (String)item);
        }
    }

    @Override
    public void selectResult(Stack<TreeNode<String, T>> result) {
        if (result.size() > 0 && this.tree != null) {
            List path = result.stream().map(TreeNode::getKey).collect(Collectors.toList());
            path.remove(0);
            this.loadPage(this.tree.jumpTo(path));
        }
    }

    @Override
    public String resultDisplay(Stack<TreeNode<String, T>> result) {
        Iterator iterator = result.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        iterator.next();
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            TreeNode node = (TreeNode)iterator.next();
            builder.append(node.getContent() == null ? (String)node.getKey() : this.itemName(node.getContent()));
            if (!iterator.hasNext()) continue;
            builder.append(" / ");
        }
        return builder.toString();
    }

    @Override
    public List<IMenuComponent> getMenuComponents() {
        return Collections.singletonList(new SearchComponent(this));
    }

    private void buildTree() {
        this.tree = new TreeListWidget<String, Object>(0, 0, this.getOs().getSize().width - 200, this.getOs().getSize().height, this.getTree(), this::loadPage).setContentIconSupplier(this::itemIcon).setContentNameSupplier(this::itemName).setKeyNameSupplier(key -> key).setNodeTexture(GuiTextures.BORDERED_BACKGROUND).setLeafTexture(GuiTextures.SLOT_DARKENED);
        this.addWidget(this.tree);
    }

    @Override
    protected void hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.tree != null) {
            this.tree.drawInBackground(mouseX, mouseY, partialTicks, context);
        }
        if (this.pageWidget != null) {
            Position position = this.pageWidget.getPosition();
            mouseX = (int)(((float)mouseX - (float)position.x * (1.0f - this.scale)) / this.scale);
            mouseY = (int)((float)mouseY / this.scale);
            GlStateManager.func_179109_b((float)((float)position.x * (1.0f - this.scale)), (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
            this.pageWidget.drawInBackground(mouseX, mouseY, partialTicks, context);
            GlStateManager.func_179152_a((float)(1.0f / this.scale), (float)(1.0f / this.scale), (float)1.0f);
            GlStateManager.func_179109_b((float)((float)position.x * (this.scale - 1.0f)), (float)0.0f, (float)0.0f);
        }
    }

    @Override
    protected void hookDrawInForeground(int mouseX, int mouseY) {
        if (this.tree != null) {
            this.tree.drawInForeground(mouseX, mouseY);
        }
        if (this.pageWidget != null) {
            Position position = this.pageWidget.getPosition();
            mouseX = (int)(((float)mouseX - (float)position.x * (1.0f - this.scale)) / this.scale);
            mouseY = (int)((float)mouseY / this.scale);
            GlStateManager.func_179109_b((float)((float)position.x * (1.0f - this.scale)), (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
            this.pageWidget.drawInForeground(mouseX, mouseY);
            GlStateManager.func_179152_a((float)(1.0f / this.scale), (float)(1.0f / this.scale), (float)1.0f);
            GlStateManager.func_179109_b((float)((float)position.x * (this.scale - 1.0f)), (float)0.0f, (float)0.0f);
        }
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        if (this.tree != null && this.tree.mouseWheelMove(mouseX, mouseY, wheelDelta)) {
            return true;
        }
        if (this.pageWidget != null) {
            Position position = this.pageWidget.getPosition();
            mouseX = (int)(((float)mouseX - (float)position.x * (1.0f - this.scale)) / this.scale);
            mouseY = (int)((float)mouseY / this.scale);
            return this.pageWidget.mouseWheelMove(mouseX, mouseY, wheelDelta);
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.tree != null && this.tree.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.pageWidget != null) {
            Position position = this.pageWidget.getPosition();
            mouseX = (int)(((float)mouseX - (float)position.x * (1.0f - this.scale)) / this.scale);
            mouseY = (int)((float)mouseY / this.scale);
            return this.pageWidget.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        if (this.tree != null && this.tree.mouseDragged(mouseX, mouseY, button, timeDragged)) {
            return true;
        }
        if (this.pageWidget != null) {
            Position position = this.pageWidget.getPosition();
            mouseX = (int)(((float)mouseX - (float)position.x * (1.0f - this.scale)) / this.scale);
            mouseY = (int)((float)mouseY / this.scale);
            return this.pageWidget.mouseDragged(mouseX, mouseY, button, timeDragged);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.tree != null && this.tree.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.pageWidget != null) {
            Position position = this.pageWidget.getPosition();
            mouseX = (int)(((float)mouseX - (float)position.x * (1.0f - this.scale)) / this.scale);
            mouseY = (int)((float)mouseY / this.scale);
            return this.pageWidget.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void onOSSizeUpdate(int width, int height) {
        this.setSize(new Size(width, height));
        int treeWidth = Math.max(133, this.getOs().getSize().width / 3);
        if (this.tree != null) {
            this.tree.setSize(new Size(treeWidth, height));
        }
        if (this.pageWidget != null) {
            this.scale = (float)(width - treeWidth) / 200.0f;
            this.pageWidget.setSize(new Size(200, (int)((float)height / this.scale)));
            this.pageWidget.setSelfPosition(new Position(treeWidth, 0));
        }
    }
}

