/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guideeditor.widget.configurator;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.common.inventory.handlers.SingleItemStackHandler;
import gregtech.common.terminal.app.guide.widget.SlotListWidget;
import gregtech.common.terminal.app.guideeditor.widget.configurator.ConfiguratorWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemStackConfigurator
extends ConfiguratorWidget<List<SlotListWidget.ItemStackInfo>> {
    DraggableScrollableWidgetGroup container;
    List<SlotListWidget.ItemStackInfo> slots;

    public ItemStackConfigurator(DraggableScrollableWidgetGroup group, JsonObject config, String name) {
        super(group, config, name);
    }

    @Override
    protected void init() {
        this.container = new DraggableScrollableWidgetGroup(0, 27, 116, 100);
        this.addWidget(this.container);
        this.addWidget(new RectButtonWidget(0, 15, 116, 10, 1).setIcon(new TextTexture("terminal.guide_editor.add_slot", -1)).setClickListener(cd -> {
            this.addSlot(this.container, new SlotListWidget.ItemStackInfo("minecraft:air", 0, 0));
            this.updateValue();
        }).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_1.getColor()));
        this.slots = new ArrayList<SlotListWidget.ItemStackInfo>();
        if (!this.config.get(this.name).isJsonNull()) {
            Gson gson = new Gson();
            for (JsonElement o : this.config.get(this.name).getAsJsonArray()) {
                this.addSlot(this.container, (SlotListWidget.ItemStackInfo)gson.fromJson(o, SlotListWidget.ItemStackInfo.class));
            }
        }
    }

    private void addSlot(DraggableScrollableWidgetGroup container, SlotListWidget.ItemStackInfo itemStackInfo) {
        WidgetGroup group = new WidgetGroup(0, this.slots.size() * 20, 116, 20);
        this.slots.add(itemStackInfo);
        SingleItemStackHandler handler = new SingleItemStackHandler(1);
        handler.setStackInSlot(0, itemStackInfo.getInstance());
        group.addWidget(new PhantomSlotWidget((IItemHandlerModifiable)handler, 0, 1, 1).setBackgroundTexture(TerminalTheme.COLOR_B_2).setChangeListener(() -> this.lambda$addSlot$1(itemStackInfo, (IItemHandlerModifiable)handler)));
        group.addWidget(new RectButtonWidget(20, 0, 20, 20).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_1.getColor()).setClickListener(data -> {
            itemStackInfo.count = Math.max(0, itemStackInfo.count - (data.isShiftClick ? 10 : 1));
            this.updateValue();
        }).setIcon(new TextTexture("-1", -1)));
        group.addWidget(new RectButtonWidget(76, 0, 20, 20).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_1.getColor()).setClickListener(data -> {
            itemStackInfo.count = Math.max(0, itemStackInfo.count + (data.isShiftClick ? 10 : 1));
            this.updateValue();
        }).setIcon(new TextTexture("+1", -1)));
        group.addWidget(new ImageWidget(40, 0, 36, 20, TerminalTheme.COLOR_B_2));
        group.addWidget(new SimpleTextWidget(58, 10, "", 0xFFFFFF, () -> Integer.toString(itemStackInfo.count), true));
        group.addWidget(new RectButtonWidget(96, 0, 20, 20).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_1.getColor()).setClickListener(data -> {
            container.waitToRemoved(group);
            this.slots.remove(itemStackInfo);
            int index = container.widgets.indexOf(group);
            for (int i = container.widgets.size() - 1; i > index; --i) {
                ((Widget)container.widgets.get(i)).addSelfPosition(0, -20);
            }
            this.updateValue();
        }).setIcon(GuiTextures.ICON_REMOVE));
        container.addWidget(group);
    }

    private void updateValue() {
        this.updateValue(this.slots);
    }

    private /* synthetic */ void lambda$addSlot$1(SlotListWidget.ItemStackInfo itemStackInfo, IItemHandlerModifiable handler) {
        itemStackInfo.update(handler.getStackInSlot(0));
        this.updateValue();
    }
}

