/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.hardwaremanager;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.hardware.Hardware;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalOSWidget;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class HardwareSlotWidget
extends WidgetGroup {
    private final Hardware hardware;
    private final TerminalOSWidget os;
    private Runnable onSelected;

    public HardwareSlotWidget(int x, int y, TerminalOSWidget os, Hardware hardware) {
        super(x, y, 20, 20);
        this.os = os;
        this.hardware = hardware;
    }

    public void setOnSelected(Runnable onSelected) {
        this.onSelected = onSelected;
    }

    private void showDialog(int button) {
        if (button == 0) {
            if (this.hardware.hasHW()) {
                this.onSelected.run();
            } else {
                TerminalDialogWidget.showItemSelector(this.os, "terminal.hardware.select", true, itemStack -> this.hardware.acceptItemStack((ItemStack)itemStack) != null, itemStack -> {
                    NBTTagCompound tag = this.hardware.acceptItemStack((ItemStack)itemStack);
                    if (tag != null) {
                        tag.func_74782_a("item", (NBTBase)itemStack.serializeNBT());
                        this.os.hardwareProvider.getOrCreateHardwareCompound().func_74782_a(this.hardware.getRegistryName(), (NBTBase)tag);
                        this.os.hardwareProvider.cleanCache(this.hardware.getRegistryName());
                    }
                }).open();
            }
        } else if (this.hardware.hasHW()) {
            boolean emptySlot = false;
            for (ItemStack itemStack2 : this.gui.entityPlayer.field_71071_by.field_70462_a) {
                if (!itemStack2.func_190926_b()) continue;
                emptySlot = true;
                break;
            }
            if (emptySlot) {
                TerminalDialogWidget.showConfirmDialog(this.os, "terminal.hardware.remove", "terminal.component.confirm", result -> {
                    if (result.booleanValue()) {
                        NBTTagCompound tag = this.os.hardwareProvider.getOrCreateHardwareCompound().func_74775_l(this.hardware.getRegistryName());
                        if (!tag.func_82582_d() && tag.func_74764_b("item")) {
                            this.gui.entityPlayer.field_71071_by.func_70441_a(this.hardware.onHardwareRemoved(new ItemStack(tag.func_74775_l("item"))));
                        }
                        this.os.hardwareProvider.getOrCreateHardwareCompound().func_82580_o(this.hardware.getRegistryName());
                        this.os.hardwareProvider.cleanCache(this.hardware.getRegistryName());
                    }
                }).open();
            } else {
                TerminalDialogWidget.showInfoDialog(this.os, "terminal.component.warning", "terminal.hardware.remove.full").open();
            }
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            this.writeClientAction(1, buffer -> buffer.func_150787_b(button));
            this.showDialog(button);
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            this.showDialog(buffer.func_150792_a());
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.hardware != null && this.isMouseOverElement(mouseX, mouseY)) {
            if (!this.hardware.hasHW()) {
                this.drawHoveringText(ItemStack.field_190927_a, Collections.singletonList(this.hardware.getLocalizedName()), 300, mouseX, mouseY);
            } else {
                String info = this.hardware.addInformation();
                if (info == null) {
                    this.drawHoveringText(ItemStack.field_190927_a, Arrays.asList(this.hardware.getLocalizedName(), I18n.func_135052_a((String)"terminal.hardware.tip.remove", (Object[])new Object[0])), 300, mouseX, mouseY);
                } else {
                    this.drawHoveringText(ItemStack.field_190927_a, Arrays.asList(String.format("%s (%s)", this.hardware.getLocalizedName(), info), I18n.func_135052_a((String)"terminal.hardware.tip.remove", (Object[])new Object[0])), 300, mouseX, mouseY);
                }
            }
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        boolean missing = !this.hardware.hasHW();
        HardwareSlotWidget.drawBorder(x - 1, y - 1, width + 2, height + 1, missing ? 0x6FFFFFFF : -1, 1);
        this.hardware.getIcon().draw(x, y, width, height);
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
    }
}

