/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe;

import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.IntCircuitRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.api.util.world.DummyWorld;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import org.apache.commons.lang3.tuple.Pair;

public class WoodMachineRecipes {
    public static void init() {
        WoodMachineRecipes.registerPyrolyseOvenRecipes();
    }

    public static void postInit() {
        WoodMachineRecipes.processLogOreDictionary();
    }

    private static void processLogOreDictionary() {
        List allWoodLogs = OreDictUnifier.getAllWithOreDictionaryName("logWood").stream().flatMap(stack -> ModHandler.getAllSubItems(stack).stream()).collect(Collectors.toList());
        for (ItemStack stack2 : allWoodLogs) {
            ItemStack outputStack;
            ItemStack slabStack;
            Pair<IRecipe, ItemStack> outputPair = ModHandler.getRecipeOutput(null, stack2);
            ItemStack plankStack = (ItemStack)outputPair.getValue();
            int originalOutput = plankStack.func_190916_E();
            if (plankStack.func_190926_b()) continue;
            IRecipe outputRecipe = (IRecipe)outputPair.getKey();
            if (ConfigHolder.recipes.nerfWoodCrafting) {
                ModHandler.removeRecipeByName(outputRecipe.getRegistryName());
                ModHandler.addShapelessRecipe(outputRecipe.getRegistryName().toString(), GTUtility.copyAmount(Math.max(1, originalOutput / 2), plankStack), stack2);
                ModHandler.addShapedRecipe(outputRecipe.getRegistryName().func_110623_a() + "_saw", GTUtility.copyAmount(originalOutput, plankStack), "s", "L", Character.valueOf('L'), stack2);
            } else {
                ModHandler.addShapedRecipe(outputRecipe.getRegistryName().func_110623_a() + "_saw", GTUtility.copyAmount((int)((double)originalOutput * 1.5), plankStack), "s", "L", Character.valueOf('L'), stack2);
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(stack2)).fluidInputs(Materials.Lubricant.getFluid(1))).outputs(GTUtility.copyAmount((int)((double)originalOutput * 1.5), plankStack), OreDictUnifier.get(OrePrefix.dust, Materials.Wood, 2))).duration(200)).EUt(GTValues.VA[0])).buildAndRegister();
            ItemStack doorStack = (ItemStack)ModHandler.getRecipeOutput(DummyWorld.INSTANCE, plankStack, plankStack, null, plankStack, plankStack, null, plankStack, plankStack, null).getRight();
            if (!doorStack.func_190926_b()) {
                ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(GTUtility.copyAmount(6, plankStack))).outputs(doorStack)).duration(600)).EUt(4)).circuitMeta(6).buildAndRegister();
            }
            if (!(slabStack = (ItemStack)ModHandler.getRecipeOutput(DummyWorld.INSTANCE, plankStack, plankStack, plankStack).getRight()).func_190926_b()) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(GTUtility.copyAmount(1, plankStack))).outputs(GTUtility.copyAmount(2, slabStack))).duration(200)).EUt(GTValues.VA[0])).buildAndRegister();
                ModHandler.addShapedRecipe(slabStack.func_82833_r() + "_saw", GTUtility.copyAmount(2, slabStack), "sS", Character.valueOf('S'), GTUtility.copyAmount(1, plankStack));
            }
            if (!ConfigHolder.recipes.harderCharcoalRecipe || (outputStack = FurnaceRecipes.func_77602_a().func_151395_a(stack2)).func_77973_b() != Items.field_151044_h || outputStack.func_77952_i() != 1) continue;
            ModHandler.removeFurnaceSmelting(stack2);
        }
    }

    private static void registerPyrolyseOvenRecipes() {
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(4).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.CharcoalByproducts.getFluid(4000))).duration(320)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(9).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodTar.getFluid(1500))).duration(640)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(10).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodTar.getFluid(1500))).duration(320)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(5).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodGas.getFluid(1500))).duration(640)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(6).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodGas.getFluid(1500))).duration(320)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(7).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodVinegar.getFluid(3000))).duration(640)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(8).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodVinegar.getFluid(3000))).duration(320)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(1).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.Creosote.getFluid(4000))).duration(640)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(2).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.Creosote.getFluid(4000))).duration(320)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(3).input(OrePrefix.log, Materials.Wood, 16)).output(OrePrefix.dust, Materials.Ash, 4)).fluidOutputs(Materials.OilHeavy.getFluid(200))).duration(320)).EUt(192)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(1).input(OrePrefix.gem, Materials.Coal, 16)).output(OrePrefix.gem, Materials.Coke, 16)).fluidOutputs(Materials.Creosote.getFluid(8000))).duration(640)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(2).input(OrePrefix.gem, Materials.Coal, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).output(OrePrefix.gem, Materials.Coke, 16)).fluidOutputs(Materials.Creosote.getFluid(8000))).duration(320)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(1).input(OrePrefix.block, Materials.Coal, 8)).output(OrePrefix.block, Materials.Coke, 8)).fluidOutputs(Materials.Creosote.getFluid(32000))).duration(2560)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(2).input(OrePrefix.block, Materials.Coal, 8)).fluidInputs(Materials.Nitrogen.getFluid(1000))).output(OrePrefix.block, Materials.Coke, 8)).fluidOutputs(Materials.Creosote.getFluid(32000))).duration(1280)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().EUt(10)).duration(200)).input(MetaItems.BIO_CHAFF)).circuitMeta(2).fluidInputs(Materials.Water.getFluid(1500))).fluidOutputs(Materials.FermentedBiomass.getFluid(1500))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().EUt(10)).duration(900)).input(MetaItems.BIO_CHAFF, 4)).circuitMeta(1).fluidInputs(Materials.Water.getFluid(4000))).fluidOutputs(Materials.Biomass.getFluid(5000))).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(1).input(OrePrefix.dust, Materials.Sugar, 23)).output(OrePrefix.dust, Materials.Charcoal, 12)).fluidOutputs(Materials.Water.getFluid(1500))).duration(320)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(2).input(OrePrefix.dust, Materials.Sugar, 23)).fluidInputs(Materials.Nitrogen.getFluid(500))).output(OrePrefix.dust, Materials.Charcoal, 12)).fluidOutputs(Materials.Water.getFluid(1500))).duration(160)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(20).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Steam.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.CoalGas.getFluid(2000))).duration(640)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(22).input(OrePrefix.gem, Materials.Coal, 16)).fluidInputs(Materials.Steam.getFluid(1000))).output(OrePrefix.gem, Materials.Coke, 16)).fluidOutputs(Materials.CoalGas.getFluid(4000))).duration(320)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(22).input(OrePrefix.block, Materials.Coal, 8)).fluidInputs(Materials.Steam.getFluid(4000))).output(OrePrefix.block, Materials.Coke, 8)).fluidOutputs(Materials.CoalGas.getFluid(16000))).duration(1280)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(8).inputs(new ItemStack(Items.field_151044_h, 32, 1))).output(OrePrefix.dustSmall, Materials.Ash, 2)).fluidOutputs(Materials.CoalTar.getFluid(1000))).duration(640)).EUt(64)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(8).inputs(new ItemStack(Items.field_151044_h, 12))).output(OrePrefix.dustSmall, Materials.DarkAsh, 2)).fluidOutputs(Materials.CoalTar.getFluid(3000))).duration(320)).EUt(96)).buildAndRegister();
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(8).input(OrePrefix.gem, Materials.Coke, 8)).output(OrePrefix.dustSmall, Materials.Ash, 3)).fluidOutputs(Materials.CoalTar.getFluid(4000))).duration(320)).EUt(96)).buildAndRegister();
    }
}

