/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.WorldTypeTools;
import mcjty.lostcities.dimensions.world.lost.BuildingInfo;
import mcjty.lostcities.dimensions.world.lost.cityassets.BuildingPart;
import mcjty.lostcities.dimensions.world.lost.cityassets.Palette;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.StringUtils;

public class CommandExportPart
implements ICommand {
    public String func_71517_b() {
        return "lc_exportpart";
    }

    public String func_71518_a(ICommandSender sender) {
        return this.func_71517_b() + " <file> <slices>";
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        try {
            int cntSlices = Integer.parseInt(args[1]);
            JsonArray array = new JsonArray();
            EntityPlayer player = (EntityPlayer)sender;
            BlockPos start = player.func_180425_c().func_177977_b();
            String palettechars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+-=[]{}\\|`~:;',./<>?";
            int idx = 0;
            HashMap<IBlockState, Character> mapping = new HashMap<IBlockState, Character>();
            Palette palette = new Palette("old");
            Palette paletteNew = new Palette("new");
            LostCityChunkGenerator provider = WorldTypeTools.getChunkGenerator(sender.func_130014_f_().field_73011_w.getDimension());
            BuildingInfo info = BuildingInfo.getBuildingInfo(start.func_177958_n() >> 4, start.func_177952_p() >> 4, provider);
            for (Character character : info.getCompiledPalette().getCharacters()) {
                IBlockState state = info.getCompiledPalette().getStraight(character.charValue());
                if (state == null) continue;
                palette.addMapping(character.charValue(), state);
                mapping.put(state, character);
            }
            ArrayList<Slice> slices = new ArrayList<Slice>();
            for (int f = 0; f < cntSlices; ++f) {
                Slice slice = new Slice();
                slices.add(slice);
                int cx = (start.func_177958_n() >> 4) * 16;
                int cy = start.func_177956_o() + f;
                int cz = (start.func_177952_p() >> 4) * 16;
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(cx, cy, cz);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        pos.func_181079_c(cx + x, cy, cz + z);
                        IBlockState state = server.func_130014_f_().func_180495_p((BlockPos)pos);
                        Character character = (Character)mapping.get(state);
                        if (character == null) {
                            do {
                                character = Character.valueOf(state.func_177230_c() == Blocks.field_150350_a ? (char)' ' : palettechars.charAt(idx));
                                ++idx;
                            } while (palette.getPalette().containsKey(character) || paletteNew.getPalette().containsKey(character));
                            paletteNew.addMapping(character.charValue(), state);
                            mapping.put(state, character);
                        }
                        slice.sequence[z * 16 + x] = "" + character;
                    }
                }
            }
            String[] sl = new String[cntSlices];
            for (int i = 0; i < cntSlices; ++i) {
                sl[i] = StringUtils.join((Object[])((Slice)slices.get((int)i)).sequence);
            }
            BuildingPart part = new BuildingPart("part", 16, 16, sl);
            array.add((JsonElement)part.writeToJSon());
            array.add((JsonElement)palette.writeToJSon());
            array.add((JsonElement)paletteNew.writeToJSon());
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (PrintWriter writer = new PrintWriter(new File(args[0]));){
                writer.print(gson.toJson((JsonElement)array));
                writer.flush();
            }
        }
        catch (FileNotFoundException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Error writing to file '" + args[0] + "'!"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }

    public static class Slice {
        String[] sequence = new String[256];
    }
}

