/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tconstruct;

import com.blamejared.ModTweaker;
import com.blamejared.compat.tconstruct.recipes.DryingRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.DryingRecipe;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Drying")
@ZenRegister
@ModOnly(value="tconstruct")
public class Drying {
    public static final Map<IItemStack, IItemStack> DRYING_RECIPES = new LinkedHashMap<IItemStack, IItemStack>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register((Object)new Drying());
            init = true;
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int time) {
        Drying.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)output), input, time));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output, @Optional IItemStack input) {
        Drying.init();
        CraftTweakerAPI.apply((IAction)new Remove(output, input));
    }

    @SubscribeEvent
    public void onTinkerRegister(TinkerRegisterEvent.DryingRackRegisterEvent event) {
        if (event.getRecipe() instanceof DryingRecipeTweaker) {
            return;
        }
        for (Map.Entry<IItemStack, IItemStack> ent : DRYING_RECIPES.entrySet()) {
            if (!ent.getKey().matches(InputHelper.toIItemStack((ItemStack)((DryingRecipe)event.getRecipe()).getResult()))) continue;
            if (ent.getValue() != null) {
                if (!((DryingRecipe)event.getRecipe()).input.matches(NonNullList.func_191197_a((int)1, (Object)((ItemStack)ent.getValue().getInternal()))).isPresent()) continue;
                event.setCanceled(true);
                continue;
            }
            event.setCanceled(true);
        }
    }

    private static class Remove
    extends BaseAction {
        private IItemStack output;
        private IItemStack input;

        protected Remove(IItemStack output, IItemStack input) {
            super("Drying");
            this.output = output;
            this.input = input;
        }

        public void apply() {
            DRYING_RECIPES.put(this.output, this.input);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class Add
    extends BaseAction {
        private final ItemStack output;
        private final IIngredient ingredient;
        private final int time;

        public Add(ItemStack output, IIngredient input, int time) {
            super("Drying");
            this.output = output;
            this.ingredient = input;
            this.time = time;
        }

        public void apply() {
            List validIngredients = this.ingredient.getItems().stream().map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
            if (validIngredients.isEmpty()) {
                CraftTweakerAPI.logInfo((String)("Could not find matching items for " + this.ingredient.toString() + ". Ignoring " + this.name + " recipe for " + this.output.func_82833_r()));
            } else {
                TinkerRegistry.addDryingRecipe((DryingRecipe)new DryingRecipeTweaker(RecipeMatch.of(validIngredients), this.output, this.time));
            }
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.output);
        }
    }
}

