/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gregtech.api.util.GTHashMaps;
import gregtech.api.util.ItemStackKey;
import gregtech.api.util.OverlayedItemHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import stanhebben.zenscript.annotations.IterableSimple;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forge.items.IItemHandlerModifiable")
@IterableSimple(value="crafttweaker.item.IItemStack")
@ZenRegister
public interface IIItemHandlerModifiable
extends Iterable<IItemStack> {
    public IItemHandlerModifiable getInner();

    @ZenMethod
    public void setStackInSlot(int var1, IItemStack var2);

    @ZenMethod
    public int getSlots();

    @ZenMethod
    public IItemStack getStackInSlot(int var1);

    @ZenMethod
    public IItemStack insertItem(int var1, IItemStack var2, boolean var3);

    @ZenMethod
    public IItemStack extractItem(int var1, int var2, boolean var3);

    @ZenMethod
    public int getSlotLimit(int var1);

    @ZenMethod
    public boolean isItemValid(int var1, IItemStack var2);

    @ZenMethod
    default public boolean addItems(boolean simulate, List<IItemStack> itemStacks) {
        IItemHandlerModifiable handler = this.getInner();
        List<ItemStack> items = itemStacks.stream().map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
        if (simulate) {
            OverlayedItemHandler overlayedItemHandler = new OverlayedItemHandler((IItemHandler)handler);
            Map stackKeyMap = GTHashMaps.fromItemStackCollection(items);
            for (Map.Entry entry : stackKeyMap.entrySet()) {
                int amountToInsert = (Integer)entry.getValue();
                int amount = overlayedItemHandler.insertStackedItemStackKey((ItemStackKey)entry.getKey(), amountToInsert);
                if (amount <= 0) continue;
                return false;
            }
            return true;
        }
        items.forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false));
        return true;
    }
}

