/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.platform;

import java.lang.management.MemoryUsage;
import me.lucko.spark.proto.SparkProtos;

public interface PlatformInfo {
    public Type getType();

    public String getName();

    public String getVersion();

    public String getMinecraftVersion();

    public int getNCpus();

    public MemoryUsage getHeapUsage();

    default public Data toData() {
        return new Data(this.getType(), this.getName(), this.getVersion(), this.getMinecraftVersion(), this.getNCpus(), this.getHeapUsage());
    }

    public static final class Data {
        private final Type type;
        private final String name;
        private final String version;
        private final String minecraftVersion;
        private final int nCpus;
        private final MemoryUsage heapUsage;

        public Data(Type type, String name, String version, String minecraftVersion, int nCpus, MemoryUsage heapUsage) {
            this.type = type;
            this.name = name;
            this.version = version;
            this.minecraftVersion = minecraftVersion;
            this.nCpus = nCpus;
            this.heapUsage = heapUsage;
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getMinecraftVersion() {
            return this.minecraftVersion;
        }

        public int getNCpus() {
            return this.nCpus;
        }

        public MemoryUsage getHeapUsage() {
            return this.heapUsage;
        }

        private static SparkProtos.MemoryData toProto(MemoryUsage usage) {
            return (SparkProtos.MemoryData)SparkProtos.MemoryData.newBuilder().setUsed(usage.getUsed()).setCommitted(usage.getCommitted()).setMax(usage.getMax()).build();
        }

        public SparkProtos.PlatformData toProto() {
            SparkProtos.PlatformData.Builder proto = SparkProtos.PlatformData.newBuilder().setType(this.type.toProto()).setName(this.name).setVersion(this.version).setNCpus(this.nCpus).setHeapUsage(Data.toProto(this.heapUsage));
            if (this.minecraftVersion != null) {
                proto.setMinecraftVersion(this.minecraftVersion);
            }
            return (SparkProtos.PlatformData)proto.build();
        }
    }

    public static enum Type {
        SERVER(SparkProtos.PlatformData.Type.SERVER),
        CLIENT(SparkProtos.PlatformData.Type.CLIENT),
        PROXY(SparkProtos.PlatformData.Type.PROXY);

        private final SparkProtos.PlatformData.Type type;

        private Type(SparkProtos.PlatformData.Type type) {
            this.type = type;
        }

        public SparkProtos.PlatformData.Type toProto() {
            return this.type;
        }
    }
}

