/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async.jfr;

public class Dictionary<T> {
    private static final int INITIAL_CAPACITY = 16;
    private long[] keys = new long[16];
    private Object[] values = new Object[16];
    private int size;

    public void put(long key, T value) {
        if (key == 0L) {
            throw new IllegalArgumentException("Zero key not allowed");
        }
        if (++this.size * 2 > this.keys.length) {
            this.resize(this.keys.length * 2);
        }
        int mask = this.keys.length - 1;
        int i = Dictionary.hashCode(key) & mask;
        while (this.keys[i] != 0L && this.keys[i] != key) {
            i = i + 1 & mask;
        }
        this.keys[i] = key;
        this.values[i] = value;
    }

    public T get(long key) {
        int mask = this.keys.length - 1;
        int i = Dictionary.hashCode(key) & mask;
        while (this.keys[i] != key && this.keys[i] != 0L) {
            i = i + 1 & mask;
        }
        return (T)this.values[i];
    }

    public void forEach(Visitor<T> visitor) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == 0L) continue;
            visitor.visit(this.keys[i], this.values[i]);
        }
    }

    public int preallocate(int count) {
        int newSize = this.size + count;
        if (newSize * 2 > this.keys.length) {
            this.resize(Integer.highestOneBit(newSize * 4 - 1));
        }
        return count;
    }

    private void resize(int newCapacity) {
        long[] newKeys = new long[newCapacity];
        Object[] newValues = new Object[newCapacity];
        int mask = newKeys.length - 1;
        block0: for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == 0L) continue;
            int j = Dictionary.hashCode(this.keys[i]) & mask;
            while (true) {
                if (newKeys[j] == 0L) {
                    newKeys[j] = this.keys[i];
                    newValues[j] = this.values[i];
                    continue block0;
                }
                j = j + 1 & mask;
            }
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    private static int hashCode(long key) {
        return (int)(key ^ key >>> 32);
    }

    public static interface Visitor<T> {
        public void visit(long var1, T var3);
    }
}

