/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.java;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.sampler.Sampler;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.java.JavaDataAggregator;
import me.lucko.spark.common.sampler.java.SimpleDataAggregator;
import me.lucko.spark.common.sampler.java.TickedDataAggregator;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.node.ThreadNode;
import me.lucko.spark.common.sampler.tick.TickHook;
import me.lucko.spark.proto.SparkProtos;

public class JavaSampler
implements Sampler,
Runnable {
    private static final AtomicInteger THREAD_ID = new AtomicInteger(0);
    private final ScheduledExecutorService workerPool = Executors.newScheduledThreadPool(6, new ThreadFactoryBuilder().setNameFormat("spark-worker-" + THREAD_ID.getAndIncrement() + "-%d").build());
    private ScheduledFuture<?> task;
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private final ThreadDumper threadDumper;
    private final JavaDataAggregator dataAggregator;
    private final CompletableFuture<JavaSampler> future = new CompletableFuture();
    private final int interval;
    private long startTime = -1L;
    private final long endTime;

    public JavaSampler(int interval, ThreadDumper threadDumper, ThreadGrouper threadGrouper, long endTime, boolean ignoreSleeping, boolean ignoreNative) {
        this.threadDumper = threadDumper;
        this.dataAggregator = new SimpleDataAggregator(this.workerPool, threadGrouper, interval, ignoreSleeping, ignoreNative);
        this.interval = interval;
        this.endTime = endTime;
    }

    public JavaSampler(int interval, ThreadDumper threadDumper, ThreadGrouper threadGrouper, long endTime, boolean ignoreSleeping, boolean ignoreNative, TickHook tickHook, int tickLengthThreshold) {
        this.threadDumper = threadDumper;
        this.dataAggregator = new TickedDataAggregator(this.workerPool, threadGrouper, interval, ignoreSleeping, ignoreNative, tickHook, tickLengthThreshold);
        this.interval = interval;
        this.endTime = endTime;
    }

    @Override
    public void start() {
        this.startTime = System.currentTimeMillis();
        this.task = this.workerPool.scheduleAtFixedRate(this, 0L, this.interval, TimeUnit.MICROSECONDS);
    }

    @Override
    public long getStartTime() {
        if (this.startTime == -1L) {
            throw new IllegalStateException("Not yet started");
        }
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    public CompletableFuture<JavaSampler> getFuture() {
        return this.future;
    }

    @Override
    public void stop() {
        this.task.cancel(false);
    }

    @Override
    public void run() {
        try {
            if (this.endTime != -1L && this.endTime <= System.currentTimeMillis()) {
                this.future.complete(this);
                this.stop();
                return;
            }
            ThreadInfo[] threadDumps = this.threadDumper.dumpThreads(this.threadBean);
            this.workerPool.execute(new InsertDataTask(this.dataAggregator, threadDumps));
        }
        catch (Throwable t) {
            this.future.completeExceptionally(t);
            this.stop();
        }
    }

    @Override
    public SparkProtos.SamplerData toProto(PlatformInfo platformInfo, CommandSender creator, Comparator<? super Map.Entry<String, ThreadNode>> outputOrder, String comment, MergeMode mergeMode) {
        SparkProtos.SamplerMetadata.Builder metadata = SparkProtos.SamplerMetadata.newBuilder().setPlatform(platformInfo.toData().toProto()).setUser(creator.toData().toProto()).setStartTime(this.startTime).setInterval(this.interval).setThreadDumper(this.threadDumper.getMetadata()).setDataAggregator(this.dataAggregator.getMetadata());
        if (comment != null) {
            metadata.setComment(comment);
        }
        SparkProtos.SamplerData.Builder proto = SparkProtos.SamplerData.newBuilder();
        proto.setMetadata((SparkProtos.SamplerMetadata)metadata.build());
        ArrayList<Map.Entry<String, ThreadNode>> data = new ArrayList<Map.Entry<String, ThreadNode>>(this.dataAggregator.getData().entrySet());
        data.sort(outputOrder);
        for (Map.Entry entry : data) {
            proto.addThreads(((ThreadNode)entry.getValue()).toProto(mergeMode));
        }
        return (SparkProtos.SamplerData)proto.build();
    }

    private static final class InsertDataTask
    implements Runnable {
        private final JavaDataAggregator dataAggregator;
        private final ThreadInfo[] threadDumps;

        InsertDataTask(JavaDataAggregator dataAggregator, ThreadInfo[] threadDumps) {
            this.dataAggregator = dataAggregator;
            this.threadDumps = threadDumps;
        }

        @Override
        public void run() {
            for (ThreadInfo threadInfo : this.threadDumps) {
                if (threadInfo.getThreadName() == null || threadInfo.getStackTrace() == null) continue;
                this.dataAggregator.insertData(threadInfo);
            }
        }
    }
}

