/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.soundmuffler.gui.data;

import edgarallen.soundmuffler.block.TileEntitySoundMuffler;
import edgarallen.soundmuffler.gui.data.IMufflerAccessor;
import edgarallen.soundmuffler.network.ThePacketeer;
import edgarallen.soundmuffler.network.messages.MessageAddRemoveSound;
import edgarallen.soundmuffler.network.messages.MessageSetRange;
import edgarallen.soundmuffler.network.messages.MessageToggleWhiteList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MufflerTileEntity
implements IMufflerAccessor {
    private final TileEntitySoundMuffler tileEntity;

    public MufflerTileEntity(TileEntitySoundMuffler tileEntity) {
        this.tileEntity = tileEntity;
    }

    @Override
    public boolean isWhiteList() {
        return this.tileEntity.isWhiteList();
    }

    @Override
    public List<ResourceLocation> getMuffledSounds() {
        return this.tileEntity.getMuffledSounds();
    }

    @Override
    public void toggleWhiteList() {
        ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageToggleWhiteList(this.tileEntity.func_174877_v(), MessageToggleWhiteList.Type.TileEntity));
    }

    @Override
    public void muffleSound(ResourceLocation sound) {
        ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageAddRemoveSound(this.tileEntity.func_174877_v(), sound, MessageAddRemoveSound.Type.TileEntity, MessageAddRemoveSound.Action.Add));
    }

    @Override
    public void unmuffleSound(ResourceLocation sound) {
        ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageAddRemoveSound(this.tileEntity.func_174877_v(), sound, MessageAddRemoveSound.Type.TileEntity, MessageAddRemoveSound.Action.Remove));
    }

    @Override
    public boolean isRanged() {
        return true;
    }

    @Override
    public int getRange() {
        return this.tileEntity.getRange();
    }

    @Override
    public int getRangeIndex() {
        return this.tileEntity.getRangeIndex();
    }

    @Override
    public void setRange(int value) {
        ThePacketeer.INSTANCE.sendToServer((IMessage)new MessageSetRange(this.tileEntity.func_174877_v(), value));
    }
}

