/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.properties;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyHelper;
import net.thedragonteam.thedragonlib.util.ArrayUtils;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class PropertyString
extends PropertyHelper<String> {
    private final List<String> valuesSet = new ArrayList<String>();

    public PropertyString(String name, String ... values) {
        super(name, String.class);
        Collections.addAll(this.valuesSet, ArrayUtils.arrayToLowercase(values));
    }

    @Nonnull
    public Collection<String> func_177700_c() {
        return ImmutableSet.copyOf(this.valuesSet);
    }

    @Nonnull
    public Optional<String> func_185929_b(@Nonnull String value) {
        return this.valuesSet.contains(value) ? Optional.of((Object)value) : Optional.absent();
    }

    @Nonnull
    public String getName(@Nonnull String value) {
        return value;
    }

    public int toMeta(String value) {
        return this.valuesSet.contains(value) ? this.valuesSet.indexOf(value) : 0;
    }

    public String fromMeta(int meta) {
        if (meta >= 0 && meta < this.valuesSet.size()) {
            return this.valuesSet.get(meta);
        }
        LogHelper.error("[PropertyString] Attempted to load property for invalid meta value");
        return this.valuesSet.get(0);
    }
}

