/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.asm.lib;

import javax.annotation.Nonnull;
import net.teamfruit.emojicord.asm.lib.ClassName;
import org.objectweb.asm.Type;

public class DescHelper {
    @Nonnull
    public static String toDescMethod(@Nonnull Object returnType, Object ... rawDesc) {
        StringBuilder sb = new StringBuilder("(");
        for (Object o : rawDesc) {
            if (o == null) continue;
            sb.append(DescHelper.toDesc(o));
        }
        sb.append(')');
        sb.append(DescHelper.toDesc(returnType));
        return sb.toString();
    }

    @Nonnull
    public static String toDesc(@Nonnull Object raw) {
        if (raw instanceof Class) {
            Class clazz = (Class)raw;
            return Type.getDescriptor((Class)clazz);
        }
        if (raw instanceof String) {
            String desc = (String)raw;
            desc = (desc = ClassName.of(desc).getBytecodeName()).matches("L.+;") ? desc : "L" + desc + ";";
            return desc;
        }
        if (raw instanceof ClassName) {
            String desc = ((ClassName)raw).getBytecodeName();
            desc = desc.matches("L.+;") ? desc : "L" + desc + ";";
            return desc;
        }
        throw new IllegalArgumentException();
    }
}

