/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.emojicord.compat;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;

public abstract class CompatTransformer
implements IClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger();

    public abstract ClassNode read(@Nonnull byte[] var1);

    public abstract byte[] write(@Nonnull ClassNode var1);

    public abstract ClassNode transform(ClassNode var1, CompatTransformerVotingContext var2);

    public abstract DeferredTransform[] deferredTransforms();

    public abstract Set<String> targetNames();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null || name == null || transformedName == null) {
            return bytes;
        }
        for (DeferredTransform transform : this.deferredTransforms()) {
            transform.transform(name, transformedName);
        }
        if (this.targetNames().contains(transformedName)) {
            try {
                ClassNode node = this.read(bytes);
                node = this.transform(node, new CompatTransformerVotingContext());
                bytes = this.write(node);
            }
            catch (Exception e) {
                LOGGER.fatal("Could not transform: ", (Throwable)e);
            }
        }
        return bytes;
    }

    public static class DeferredTransform {
        private final String thisname;
        private final String targetname;
        private boolean targetinitialized;
        private boolean targetfound;
        private Supplier<List<?>> tweakClassNamesSupplier = Suppliers.memoize(() -> (List)Launch.blackboard.get("TweakClasses"));

        public DeferredTransform(String thisname, String targetname) {
            this.thisname = thisname;
            this.targetname = targetname;
        }

        public boolean hasTarget() {
            return this.targetfound;
        }

        private boolean transformEqual(String transformName, String className) {
            return StringUtils.equals((CharSequence)transformName, (CharSequence)className) || StringUtils.equals((CharSequence)transformName, (CharSequence)("$wrapper." + className));
        }

        public void transform(String name, String transformedName) {
            if (this.transformEqual(transformedName, this.targetname)) {
                this.targetfound = true;
            }
            if (!((List)this.tweakClassNamesSupplier.get()).isEmpty()) {
                return;
            }
            if (!this.targetinitialized) {
                this.targetinitialized = true;
                this.apply();
            }
        }

        public void apply() {
            try {
                Field $transformers = Class.forName("net.minecraft.launchwrapper.LaunchClassLoader").getDeclaredField("transformers");
                $transformers.setAccessible(true);
                List transformers = (List)$transformers.get(Class.forName("net.minecraft.launchwrapper.Launch").getField("classLoader").get(null));
                int thistransformer = -1;
                int targettransformer = -1;
                ListIterator itr = transformers.listIterator();
                while (itr.hasNext()) {
                    int index = itr.nextIndex();
                    Object transformer = itr.next();
                    String tname = transformer.getClass().getName();
                    if (this.transformEqual(tname, this.thisname)) {
                        thistransformer = index;
                        continue;
                    }
                    if (!this.transformEqual(tname, this.targetname)) continue;
                    targettransformer = index;
                }
                if (thistransformer >= 0 && targettransformer >= 0 && targettransformer > thistransformer) {
                    Collections.swap(transformers, thistransformer, targettransformer);
                    LOGGER.info("The order of EmojicordTransformer and IntelliInputTransformer has been swapped while loading");
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class CompatTransformerVotingContext {
    }
}

