/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.config.impl;

import io.github.lxgaming.sledgehammer.lib.config.ConfigOrigin;
import io.github.lxgaming.sledgehammer.lib.config.ConfigValueType;
import io.github.lxgaming.sledgehammer.lib.config.impl.ConfigNumber;
import io.github.lxgaming.sledgehammer.lib.config.impl.SerializedConfigValue;
import java.io.ObjectStreamException;
import java.io.Serializable;

final class ConfigLong
extends ConfigNumber
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final long value;

    ConfigLong(ConfigOrigin origin, long value, String originalText) {
        super(origin, originalText);
        this.value = value;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.NUMBER;
    }

    @Override
    public Long unwrapped() {
        return this.value;
    }

    @Override
    String transformToString() {
        String s2 = super.transformToString();
        if (s2 == null) {
            return Long.toString(this.value);
        }
        return s2;
    }

    @Override
    protected long longValue() {
        return this.value;
    }

    @Override
    protected double doubleValue() {
        return this.value;
    }

    @Override
    protected ConfigLong newCopy(ConfigOrigin origin) {
        return new ConfigLong(origin, this.value, this.originalText);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }
}

