/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncSSSSettingsOnServer {
    private BlockPos pos;
    private DataType dataType;
    private BlockPos posToRemove;

    public SyncSSSSettingsOnServer() {
    }

    public SyncSSSSettingsOnServer(BlockPos pos, DataType dataType) {
        this(pos, dataType, null);
    }

    public SyncSSSSettingsOnServer(BlockPos pos, DataType dataType, BlockPos posToRemove) {
        this.pos = pos;
        this.dataType = dataType;
        this.posToRemove = posToRemove;
    }

    public static void encode(SyncSSSSettingsOnServer message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.m_130068_((Enum)message.dataType);
        if (message.dataType == DataType.REMOVE_POS) {
            buf.m_130064_(message.posToRemove);
        }
    }

    public static SyncSSSSettingsOnServer decode(FriendlyByteBuf buf) {
        SyncSSSSettingsOnServer message = new SyncSSSSettingsOnServer();
        message.pos = buf.m_130135_();
        message.dataType = (DataType)buf.m_130066_(DataType.class);
        if (message.dataType == DataType.REMOVE_POS) {
            message.posToRemove = buf.m_130135_();
        }
        return message;
    }

    public static void onMessage(SyncSSSSettingsOnServer message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            SonicSecuritySystemBlockEntity sss;
            Level level = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            BlockPos pos = message.pos;
            BlockEntity patt1662$temp = level.m_7702_(pos);
            if (patt1662$temp instanceof SonicSecuritySystemBlockEntity && (sss = (SonicSecuritySystemBlockEntity)patt1662$temp).isOwnedBy((Player)((NetworkEvent.Context)ctx.get()).getSender())) {
                switch (message.dataType) {
                    case POWER_ON: {
                        sss.setActive(true);
                        break;
                    }
                    case POWER_OFF: {
                        sss.setActive(false);
                        if (!sss.isRecording()) break;
                        sss.setRecording(false);
                        break;
                    }
                    case SOUND_ON: {
                        sss.setPings(true);
                        break;
                    }
                    case SOUND_OFF: {
                        sss.setPings(false);
                        break;
                    }
                    case RECORDING_ON: {
                        sss.setRecording(true);
                        break;
                    }
                    case RECORDING_OFF: {
                        sss.setRecording(false);
                        break;
                    }
                    case CLEAR_NOTES: {
                        sss.clearNotes();
                        break;
                    }
                    case REMOVE_POS: {
                        sss.delink(message.posToRemove, false);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum DataType {
        POWER_ON,
        POWER_OFF,
        SOUND_ON,
        SOUND_OFF,
        RECORDING_ON,
        RECORDING_OFF,
        CLEAR_NOTES,
        REMOVE_POS;

    }
}

