/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut.select;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import de.mari_023.ae2wtlib.wut.select.AngleHelper;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Color;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class WUTSelectScreen
extends Screen {
    private final List<String> terminals = new ArrayList<String>();

    public WUTSelectScreen(ItemStack terminal) {
        super((Component)Component.m_237115_((String)"gui.ae2wtlib.wireless_universal_terminal"));
        for (String currentTerminal : WUTHandler.terminalNames) {
            if (!WUTHandler.hasTerminal(terminal, currentTerminal)) continue;
            this.terminals.add(currentTerminal);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int angle = 360 / this.terminals.size();
        float hWidth = (float)this.f_96543_ / 2.0f;
        float hHeight = (float)this.f_96544_ / 2.0f;
        int selected = (int)AngleHelper.getAngle((float)mouseX - hWidth, (float)mouseY - hHeight) / angle;
        for (int i = 0; i < this.terminals.size(); ++i) {
            WUTSelectScreen.drawSegment(poseStack, i * angle, (i + 1) * angle, hWidth, hHeight, 100, 50, Color.ofRGB((int)125, (int)125, (int)125), i == selected);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public static void drawSegment(PoseStack poseStack, int startingAngle, int endingAngle, float centerX, float centerY, int outerRadius, int innerRadius, Color color, boolean selected) {
        float y;
        float x;
        int i;
        if (selected) {
            outerRadius += 10;
            color = color.darker(2.0);
        }
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        Matrix4f modelMatrix = poseStack.m_85850_().m_85861_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        for (i = endingAngle; i >= startingAngle; --i) {
            x = AngleHelper.getX(i, outerRadius);
            y = AngleHelper.getY(i, outerRadius);
            bufferBuilder.m_85982_(modelMatrix, centerX + x, centerY - y, 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        }
        for (i = startingAngle; i <= endingAngle; ++i) {
            x = AngleHelper.getX(i, innerRadius);
            y = AngleHelper.getY(i, innerRadius);
            bufferBuilder.m_85982_(modelMatrix, centerX + x, centerY - y, 0.0f).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }

    public boolean m_7043_() {
        return false;
    }
}

