/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.handler.lootmodifier;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.aiotbotania.core.Registration;
import de.melanx.aiotbotania.items.alfsteel.ItemAlfsteelAIOT;
import de.melanx.aiotbotania.items.terrasteel.ItemTerraSteelAIOT;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import vazkii.botania.common.lib.BotaniaTags;

public class DisposeModifier
extends LootModifier {
    public static final Supplier<Codec<DisposeModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(instance -> DisposeModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, DisposeModifier::new)));

    public DisposeModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    public static void filterDisposable(ObjectArrayList<ItemStack> drops, Entity entity, ItemStack stack) {
        if (!stack.m_41619_() && (stack.m_41720_() == Registration.elementium_aiot.get() || stack.m_41720_() == Registration.terrasteel_aiot.get() && ItemTerraSteelAIOT.isTipped(stack) || stack.m_41720_() == Registration.alfsteel_aiot.get() && ItemAlfsteelAIOT.isTipped(stack))) {
            drops.removeIf(s -> !s.m_41619_() && (DisposeModifier.isDisposable(s) || DisposeModifier.isSemiDisposable(s) && !entity.m_6047_()));
        }
    }

    private static boolean isDisposable(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_204117_(BotaniaTags.Items.DISPOSABLE);
    }

    private static boolean isSemiDisposable(ItemStack stack) {
        return stack.m_204117_(BotaniaTags.Items.SEMI_DISPOSABLE);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (entity != null && tool != null && !tool.m_41619_()) {
            DisposeModifier.filterDisposable(generatedLoot, entity, tool);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

