/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.owner;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.util.InventoryUtil;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BasePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtleFuelAbility;
import de.srendi.advancedperipherals.common.util.DataStorageUtil;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import de.srendi.advancedperipherals.common.util.fakeplayer.FakePlayerProviderTurtle;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurtlePeripheralOwner
extends BasePeripheralOwner {
    public final ITurtleAccess turtle;
    public final TurtleSide side;

    public TurtlePeripheralOwner(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
    }

    @Override
    @Nullable
    public String getCustomName() {
        return null;
    }

    @Override
    @NotNull
    public Level getLevel() {
        return this.turtle.getLevel();
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return this.turtle.getPosition();
    }

    @Override
    @NotNull
    public Direction getFacing() {
        return this.turtle.getDirection();
    }

    @Override
    @NotNull
    public FrontAndTop getOrientation() {
        return FrontAndTop.NORTH_UP;
    }

    @Override
    @Nullable
    public Player getOwner() {
        GameProfile owningPlayer = this.turtle.getOwningPlayer();
        if (owningPlayer == null) {
            return null;
        }
        return this.turtle.getLevel().m_46003_(owningPlayer.getId());
    }

    @Override
    @NotNull
    public CompoundTag getDataStorage() {
        return DataStorageUtil.getDataStorage(this.turtle, this.side);
    }

    @Override
    public void markDataStorageDirty() {
        this.turtle.updateUpgradeNBTData(this.side);
    }

    @Override
    public <T> T withPlayer(Function<APFakePlayer, T> function) {
        return FakePlayerProviderTurtle.withPlayer(this.turtle, function);
    }

    @Override
    public ItemStack getToolInMainHand() {
        return this.turtle.getInventory().m_8020_(this.turtle.getSelectedSlot());
    }

    @Override
    public ItemStack storeItem(ItemStack stored) {
        return InventoryUtil.storeItems((ItemStack)stored, (IItemHandler)this.turtle.getItemHandler(), (int)this.turtle.getSelectedSlot());
    }

    @Override
    public void destroyUpgrade() {
        this.turtle.setUpgrade(this.side, null);
    }

    @Override
    public boolean isMovementPossible(@NotNull Level level, @NotNull BlockPos pos) {
        return FakePlayerProviderTurtle.withPlayer(this.turtle, player -> {
            if (level.m_151570_(pos)) {
                return false;
            }
            if (!level.m_46739_(pos)) {
                return false;
            }
            if (ComputerCraft.turtlesObeyBlockProtection && !TurtlePermissions.isBlockEnterable((Level)level, (BlockPos)pos, (Player)player)) {
                return false;
            }
            if (!level.isAreaLoaded(pos, 0)) {
                return false;
            }
            return level.m_6857_().m_61937_(pos);
        });
    }

    @Override
    public boolean move(@NotNull Level level, @NotNull BlockPos pos) {
        return this.turtle.teleportTo(level, pos);
    }

    @NotNull
    public ITurtleAccess getTurtle() {
        return this.turtle;
    }

    @NotNull
    public TurtleSide getSide() {
        return this.side;
    }

    public TurtlePeripheralOwner attachFuel(int maxFuelConsumptionLevel) {
        this.attachAbility(PeripheralOwnerAbility.FUEL, new TurtleFuelAbility(this, maxFuelConsumptionLevel));
        return this;
    }
}

