/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.SimpleMapCodec;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.placebo.codec.EnumCodec;
import shadows.placebo.color.GradientColor;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.TypeKeyed;
import shadows.placebo.json.WeightedJsonReloadListener;

public class LootRarity
implements WeightedJsonReloadListener.ILuckyWeighted,
Comparable<LootRarity> {
    public static final List<LootRarity> LIST;
    public static final Map<String, LootRarity> BY_ID;
    public static final Codec<LootRarity> CODEC;
    public static final LootRarity COMMON;
    public static final LootRarity UNCOMMON;
    public static final LootRarity RARE;
    public static final LootRarity EPIC;
    public static final LootRarity MYTHIC;
    public static final LootRarity ANCIENT;
    private final String id;
    private final TextColor color;
    private final int ordinal;
    private int weight;
    private float quality;
    private List<LootRule> rules;

    private LootRarity(String id, TextColor color, int ordinal, int weight, float quality, List<LootRule> rules) {
        this.id = id;
        this.color = color;
        this.ordinal = ordinal;
        this.weight = weight;
        this.quality = quality;
        this.rules = rules;
    }

    private LootRarity(String id, int color, int ordinal, int weight, float quality, List<LootRule> rules) {
        this(id, TextColor.m_131266_((int)color), ordinal, weight, quality, rules);
    }

    public String id() {
        return this.id;
    }

    public TextColor color() {
        return this.color;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    public List<LootRule> rules() {
        return this.rules;
    }

    public LootRarity prev() {
        if (this == COMMON) {
            return this;
        }
        return LIST.get(this.ordinal - 1);
    }

    public LootRarity next() {
        if (this == ANCIENT) {
            return this;
        }
        return LIST.get(this.ordinal + 1);
    }

    public boolean isAtMost(LootRarity other) {
        return this.ordinal() <= other.ordinal();
    }

    public boolean isAtLeast(LootRarity other) {
        return this.ordinal() >= other.ordinal();
    }

    public static LootRarity min(LootRarity a, @Nullable LootRarity b) {
        if (b == null) {
            return a;
        }
        return a.ordinal <= b.ordinal ? a : b;
    }

    public static LootRarity max(LootRarity a, @Nullable LootRarity b) {
        if (b == null) {
            return a;
        }
        return a.ordinal >= b.ordinal ? a : b;
    }

    public static boolean isRarityMat(ItemStack stack) {
        return AdventureModule.RARITY_MATERIALS.containsValue((Object)stack.m_41720_());
    }

    @Nullable
    public static LootRarity getMaterialRarity(ItemStack stack) {
        return (LootRarity)AdventureModule.RARITY_MATERIALS.inverse().get((Object)stack.m_41720_());
    }

    public ItemStack getMaterial() {
        return new ItemStack((ItemLike)AdventureModule.RARITY_MATERIALS.get((Object)this));
    }

    public LootRarity clamp(@Nullable LootRarity lowerBound, @Nullable LootRarity upperBound) {
        return LootRarity.max(LootRarity.min(this, upperBound), lowerBound);
    }

    public Component toComponent() {
        return Component.m_237115_((String)("rarity.apoth." + this.id)).m_130948_(Style.f_131099_.m_131148_(this.color));
    }

    void update(RarityStub stub) {
        this.weight = stub.weight;
        this.quality = stub.quality;
        this.rules = ImmutableList.copyOf(stub.rules);
    }

    public String toString() {
        return "LootRarity{" + this.id + "}";
    }

    @Nullable
    public static LootRarity byId(String id) {
        return BY_ID.get(id.toLowerCase(Locale.ROOT));
    }

    public static Set<String> ids() {
        return BY_ID.keySet();
    }

    public static List<LootRarity> values() {
        return LIST;
    }

    public static LootRarity random(RandomSource rand, float luck) {
        return LootRarity.random(rand, luck, null, null);
    }

    public static LootRarity random(RandomSource rand, float luck, @Nullable Clamped item) {
        if (item == null) {
            return LootRarity.random(rand, luck);
        }
        return LootRarity.random(rand, luck, item.getMinRarity(), item.getMaxRarity());
    }

    public static LootRarity random(RandomSource rand, float luck, @Nullable LootRarity min, @Nullable LootRarity max) {
        List<WeightedEntry.Wrapper> list = LIST.stream().filter(r -> r.clamp(min, max) == r).map(r -> r.wrap(luck)).toList();
        return WeightedRandom.m_216822_((RandomSource)rand, list).map(WeightedEntry.Wrapper::m_146310_).get();
    }

    public static <T> SimpleMapCodec<LootRarity, T> mapCodec(Codec<T> codec) {
        return Codec.simpleMap(CODEC, codec, (Keyable)Keyable.forStrings(() -> LootRarity.values().stream().map(LootRarity::id)));
    }

    @Override
    public int compareTo(LootRarity o) {
        return Integer.compare(this.ordinal, o.ordinal);
    }

    static {
        CODEC = ExtraCodecs.m_184405_(LootRarity::id, LootRarity::byId);
        COMMON = new LootRarity("common", 0x808080, 0, 400, 0.0f, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 0.25f)));
        UNCOMMON = new LootRarity("uncommon", 0x33FF33, 1, 320, 1.5f, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 0.45f, new LootRule(AffixType.ABILITY, 0.25f)), (Object)new LootRule(AffixType.SOCKET, 0.45f)));
        RARE = new LootRarity("rare", 0x5555FF, 2, 150, 3.0f, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.25f)), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 0.33f), (Object)new LootRule(AffixType.SOCKET, 0.65f), (Object)new LootRule(AffixType.SOCKET, 0.45f), (Object)new LootRule(AffixType.DURABILITY, 0.1f)));
        EPIC = new LootRarity("epic", 0xBB00BB, 3, 90, 4.5f, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.45f)), (Object)new LootRule(AffixType.STAT, 0.5f, new LootRule(AffixType.ABILITY, 0.33f)), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 0.65f), (Object)new LootRule(AffixType.SOCKET, 0.85f), (Object)new LootRule(AffixType.SOCKET, 0.65f), (Object)new LootRule(AffixType.SOCKET, 0.45f), (Object)new LootRule(AffixType.DURABILITY, 0.3f)));
        MYTHIC = new LootRarity("mythic", 15560724, 4, 40, 6.0f, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.5f)), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.4f)), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 0.3f), (Object)new LootRule(AffixType.SOCKET, 1.0f), (Object)new LootRule(AffixType.SOCKET, 0.85f), (Object)new LootRule(AffixType.SOCKET, 0.65f), (Object)new LootRule(AffixType.DURABILITY, 0.5f)));
        ANCIENT = new LootRarity("ancient", (TextColor)GradientColor.RAINBOW, 5, 0, 0.0f, (List<LootRule>)ImmutableList.of((Object)new LootRule(AffixType.ANCIENT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.7f)), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.6f)), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.5f)), (Object)new LootRule(AffixType.STAT, 1.0f, new LootRule(AffixType.ABILITY, 0.4f)), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 1.0f), (Object)new LootRule(AffixType.ABILITY, 0.75f), (Object)new LootRule(AffixType.ABILITY, 0.45f), (Object)new LootRule(AffixType.SOCKET, 1.0f), (Object)new LootRule(AffixType.SOCKET, 0.85f), (Object[])new LootRule[]{new LootRule(AffixType.SOCKET, 0.65f), new LootRule(AffixType.SOCKET, 0.45f), new LootRule(AffixType.SOCKET, 0.25f), new LootRule(AffixType.DURABILITY, 0.75f)}));
        LIST = ImmutableList.of((Object)COMMON, (Object)UNCOMMON, (Object)RARE, (Object)EPIC, (Object)MYTHIC, (Object)ANCIENT);
        BY_ID = ImmutableMap.copyOf(LIST.stream().collect(Collectors.toMap(LootRarity::id, Function.identity())));
    }

    public static class RarityStub
    extends TypeKeyed.TypeKeyedBase<RarityStub>
    implements WeightedJsonReloadListener.ILuckyWeighted {
        public static final Codec<RarityStub> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedJsonReloadListener.ILuckyWeighted::getWeight), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedJsonReloadListener.ILuckyWeighted::getQuality), (App)new ListCodec(LootRule.CODEC).fieldOf("rules").forGetter(RarityStub::rules)).apply((Applicative)inst, RarityStub::new));
        public static final PSerializer<RarityStub> SERIALIZER = PSerializer.fromCodec((String)"Loot Rarity", CODEC);
        int weight;
        float quality;
        List<LootRule> rules;

        public RarityStub(int weight, float quality, List<LootRule> rules) {
            this.weight = weight;
            this.quality = quality;
            this.rules = rules;
        }

        public int getWeight() {
            return this.weight;
        }

        public float getQuality() {
            return this.quality;
        }

        public List<LootRule> rules() {
            return this.rules;
        }

        public PSerializer<? extends RarityStub> getSerializer() {
            return SERIALIZER;
        }
    }

    public static interface Clamped {
        public LootRarity getMinRarity();

        public LootRarity getMaxRarity();

        default public LootRarity clamp(@Nullable LootRarity rarity) {
            if (rarity == null) {
                return this.getMinRarity();
            }
            return rarity.clamp(this.getMinRarity(), this.getMaxRarity());
        }

        public record Impl(LootRarity min, LootRarity max) implements Clamped
        {
            @Override
            public LootRarity getMinRarity() {
                return this.min;
            }

            @Override
            public LootRarity getMaxRarity() {
                return this.max;
            }
        }
    }

    public record LootRule(AffixType type, float chance, @Nullable LootRule backup) {
        public static final Codec<LootRule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)new EnumCodec(AffixType.class).fieldOf("type").forGetter(LootRule::type), (App)Codec.FLOAT.fieldOf("chance").forGetter(LootRule::chance), (App)ExtraCodecs.m_184415_(() -> CODEC).optionalFieldOf("backup").forGetter(rule -> Optional.ofNullable(rule.backup()))).apply((Applicative)inst, LootRule::new));
        private static Random jRand = new Random();

        public LootRule(AffixType type, float chance) {
            this(type, chance, Optional.empty());
        }

        public LootRule(AffixType type, float chance, Optional<LootRule> backup) {
            this(type, chance, (LootRule)backup.orElse(null));
        }

        public void execute(ItemStack stack, LootRarity rarity, Set<Affix> currentAffixes, MutableInt sockets, RandomSource rand) {
            if (this.type == AffixType.DURABILITY) {
                return;
            }
            if (rand.m_188501_() <= this.chance) {
                if (this.type == AffixType.SOCKET) {
                    sockets.add(1);
                    return;
                }
                List available = AffixHelper.byType(this.type).stream().filter(a -> a.canApplyTo(stack, LootCategory.forItem(stack), rarity) && !currentAffixes.contains(a)).collect(Collectors.toList());
                if (available.size() == 0) {
                    if (this.backup != null) {
                        this.backup.execute(stack, rarity, currentAffixes, sockets, rand);
                    } else {
                        AdventureModule.LOGGER.error("Failed to execute LootRule {}/{}/{}/{}!", (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), (Object)rarity.id(), (Object)this.type, (Object)Float.valueOf(this.chance));
                    }
                    return;
                }
                jRand.setSeed(rand.m_188505_());
                Collections.shuffle(available, jRand);
                currentAffixes.add((Affix)((Object)available.get(0)));
            }
        }
    }
}

