/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.table;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.ench.EnchModule;
import shadows.apotheosis.ench.api.IEnchantingBlock;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.TypeKeyed;

public class EnchantingStatManager
extends PlaceboJsonReloadListener<BlockStats> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final EnchantingStatManager INSTANCE = new EnchantingStatManager();
    private final Map<Block, Stats> statsPerBlock = new HashMap<Block, Stats>();
    private float absoluteMaxEterna = 50.0f;

    protected EnchantingStatManager() {
        super(EnchModule.LOGGER, "enchanting_stats", true, false);
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, BlockStats.SERIALIZER);
    }

    protected void beginReload() {
        super.beginReload();
        this.statsPerBlock.clear();
    }

    protected void onReload() {
        super.onReload();
        for (BlockStats bStats : this.registry.values()) {
            bStats.blocks.forEach(b -> this.statsPerBlock.put((Block)b, bStats.stats));
        }
        this.computeAbsoluteMaxEterna();
    }

    public static float getEterna(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).eterna;
        }
        return state.getEnchantPowerBonus((LevelReader)world, pos);
    }

    public static float getMaxEterna(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).maxEterna;
        }
        return ((IEnchantingBlock)block).getMaxEnchantingPower(state, (LevelReader)world, pos);
    }

    public static float getQuanta(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).quanta;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getQuantaBonus(state, (LevelReader)world, pos);
        }
        return 0.0f;
    }

    public static float getArcana(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).arcana;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getArcanaBonus(state, (LevelReader)world, pos);
        }
        return 0.0f;
    }

    public static float getQuantaRectification(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).rectification;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getQuantaRectification(state, (LevelReader)world, pos);
        }
        return 0.0f;
    }

    public static int getBonusClues(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (EnchantingStatManager.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatManager.INSTANCE.statsPerBlock.get((Object)block).clues;
        }
        if (block instanceof IEnchantingBlock) {
            return ((IEnchantingBlock)block).getBonusClues(state, (LevelReader)world, pos);
        }
        return 0;
    }

    public static float getAbsoluteMaxEterna() {
        return EnchantingStatManager.INSTANCE.absoluteMaxEterna;
    }

    private void computeAbsoluteMaxEterna() {
        this.absoluteMaxEterna = this.registry.values().stream().max(Comparator.comparingDouble((ToDoubleFunction<BlockStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$computeAbsoluteMaxEterna$1(shadows.apotheosis.ench.table.EnchantingStatManager$BlockStats ), (Lshadows/apotheosis/ench/table/EnchantingStatManager$BlockStats;)D)())).get().stats.maxEterna;
    }

    private static /* synthetic */ double lambda$computeAbsoluteMaxEterna$1(BlockStats s) {
        return s.stats.maxEterna;
    }

    public static class BlockStats
    extends TypeKeyed.TypeKeyedBase<BlockStats> {
        public static Codec<BlockStats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.list((Codec)ForgeRegistries.BLOCKS.getCodec()).optionalFieldOf("blocks", Collections.emptyList()).forGetter(bs -> bs.blocks), (App)TagKey.m_203877_((ResourceKey)Registry.f_122901_).optionalFieldOf("tag").forGetter(bs -> Optional.empty()), (App)ForgeRegistries.BLOCKS.getCodec().optionalFieldOf("block").forGetter(bs -> Optional.empty()), (App)Stats.CODEC.fieldOf("stats").forGetter(bs -> bs.stats)).apply((Applicative)inst, BlockStats::new));
        public static final PSerializer<BlockStats> SERIALIZER = PSerializer.fromCodec((String)"Enchanting Stats", CODEC);
        public final List<Block> blocks = new ArrayList<Block>();
        public final Stats stats;

        public BlockStats(List<Block> blocks, Optional<TagKey<Block>> tag, Optional<Block> block, Stats stats) {
            if (!blocks.isEmpty()) {
                this.blocks.addAll(blocks);
            }
            if (tag.isPresent()) {
                this.blocks.addAll(INSTANCE.getContext().getTag(tag.get()).stream().map(Holder::m_203334_).toList());
            }
            if (block.isPresent()) {
                this.blocks.add(block.get());
            }
            this.stats = stats;
        }

        public PSerializer<? extends BlockStats> getSerializer() {
            return SERIALIZER;
        }
    }

    public record Stats(float maxEterna, float eterna, float quanta, float arcana, float rectification, int clues) {
        public static Codec<Stats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.optionalFieldOf("maxEterna", (Object)Float.valueOf(15.0f)).forGetter(Stats::maxEterna), (App)Codec.FLOAT.optionalFieldOf("eterna", (Object)Float.valueOf(0.0f)).forGetter(Stats::eterna), (App)Codec.FLOAT.optionalFieldOf("quanta", (Object)Float.valueOf(0.0f)).forGetter(Stats::quanta), (App)Codec.FLOAT.optionalFieldOf("arcana", (Object)Float.valueOf(0.0f)).forGetter(Stats::arcana), (App)Codec.FLOAT.optionalFieldOf("rectification", (Object)Float.valueOf(0.0f)).forGetter(Stats::rectification), (App)Codec.INT.optionalFieldOf("clues", (Object)0).forGetter(Stats::clues)).apply((Applicative)inst, Stats::new));

        public void write(FriendlyByteBuf buf) {
            buf.writeFloat(this.maxEterna);
            buf.writeFloat(this.eterna);
            buf.writeFloat(this.quanta);
            buf.writeFloat(this.arcana);
            buf.writeFloat(this.rectification);
            buf.writeByte(this.clues);
        }

        public static Stats read(FriendlyByteBuf buf) {
            return new Stats(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readByte());
        }
    }
}

