/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.helper.MathHelper;

public abstract class BindableSpecialFlowerBlockEntity<T>
extends SpecialFlowerBlockEntity
implements WandBindable {
    private final Class<T> bindClass;
    @Nullable
    protected BlockPos bindingPos = null;
    private static final String TAG_BINDING = "binding";

    public BindableSpecialFlowerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Class<T> bindClass) {
        super(type, pos, state);
        this.bindClass = bindClass;
    }

    public abstract int getBindingRadius();

    @Nullable
    public abstract BlockPos findClosestTarget();

    @Override
    protected void tickFlower() {
        super.tickFlower();
        if (!(this.ticksExisted != 1 || this.f_58857_.f_46443_ || this.bindingPos != null && this.isValidBinding())) {
            this.setBindingPos(this.findClosestTarget());
        }
    }

    @Nullable
    public BlockPos getBindingPos() {
        return this.bindingPos;
    }

    public void setBindingPos(@Nullable BlockPos bindingPos) {
        boolean changed = !Objects.equals(this.bindingPos, bindingPos);
        this.bindingPos = bindingPos;
        if (changed) {
            this.m_6596_();
            this.sync();
        }
    }

    @Nullable
    public T findBindCandidateAt(BlockPos pos) {
        if (this.f_58857_ == null || pos == null) {
            return null;
        }
        BlockEntity be = this.f_58857_.m_7702_(pos);
        return (T)(be != null && this.bindClass.isAssignableFrom(be.getClass()) ? be : null);
    }

    @Nullable
    public T findBoundTile() {
        return this.findBindCandidateAt(this.bindingPos);
    }

    public boolean wouldBeValidBinding(@Nullable BlockPos pos) {
        if (this.f_58857_ == null || pos == null || !this.f_58857_.m_46749_(pos) || MathHelper.distSqr((Vec3i)this.m_58899_(), (Vec3i)pos) > (long)this.getBindingRadius() * (long)this.getBindingRadius()) {
            return false;
        }
        return this.findBindCandidateAt(pos) != null;
    }

    public boolean isValidBinding() {
        return this.wouldBeValidBinding(this.bindingPos);
    }

    @Override
    public BlockPos getBinding() {
        return this.isValidBinding() ? this.bindingPos : null;
    }

    @Override
    public boolean canSelect(Player player, ItemStack wand, BlockPos pos, Direction side) {
        return true;
    }

    @Override
    public boolean bindTo(Player player, ItemStack wand, BlockPos pos, Direction side) {
        if (this.wouldBeValidBinding(pos)) {
            this.setBindingPos(pos);
            return true;
        }
        return false;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        if (this.bindingPos != null) {
            cmp.m_128365_(TAG_BINDING, (Tag)NbtUtils.m_129224_((BlockPos)this.bindingPos));
        }
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        if (cmp.m_128441_(TAG_BINDING)) {
            this.bindingPos = NbtUtils.m_129239_((CompoundTag)cmp.m_128469_(TAG_BINDING));
        } else {
            if (cmp.m_128441_("collectorX")) {
                this.bindingPos = new BlockPos(cmp.m_128451_("collectorX"), cmp.m_128451_("collectorY"), cmp.m_128451_("collectorZ"));
            } else if (cmp.m_128441_("poolX")) {
                this.bindingPos = new BlockPos(cmp.m_128451_("poolX"), cmp.m_128451_("poolY"), cmp.m_128451_("poolZ"));
            }
            if (this.bindingPos != null && this.bindingPos.m_123342_() == -1) {
                this.bindingPos = null;
            }
        }
    }

    public abstract int getMana();

    public abstract void addMana(int var1);

    public abstract int getMaxMana();

    public abstract int getColor();

    public abstract ItemStack getDefaultHudIcon();

    public ItemStack getHudIcon() {
        T boundTile = this.findBoundTile();
        if (boundTile != null) {
            return new ItemStack((ItemLike)((BlockEntity)boundTile).m_58900_().m_60734_().m_5456_());
        }
        return this.getDefaultHudIcon();
    }

    public static class BindableFlowerWandHud<F extends BindableSpecialFlowerBlockEntity<?>>
    implements WandHUD {
        protected final F flower;

        public BindableFlowerWandHud(F flower) {
            this.flower = flower;
        }

        public void renderHUD(PoseStack ms, Minecraft mc, int minLeft, int minRight, int minDown) {
            String name = I18n.m_118938_((String)this.flower.m_58900_().m_60734_().m_7705_(), (Object[])new Object[0]);
            int color = ((BindableSpecialFlowerBlockEntity)this.flower).getColor();
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            int left = (Math.max(102, mc.f_91062_.m_92895_(name)) + 4) / 2;
            int right = left + 20;
            left = Math.max(left, minLeft);
            right = Math.max(right, minRight);
            RenderHelper.renderHUDBox(ms, centerX - left, centerY + 8, centerX + right, centerY + Math.max(30, minDown));
            BotaniaAPIClient.instance().drawComplexManaHUD(ms, color, ((BindableSpecialFlowerBlockEntity)this.flower).getMana(), ((BindableSpecialFlowerBlockEntity)this.flower).getMaxMana(), name, ((BindableSpecialFlowerBlockEntity)this.flower).getHudIcon(), ((BindableSpecialFlowerBlockEntity)this.flower).isValidBinding());
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            this.renderHUD(ms, mc, 0, 0, 0);
        }
    }
}

