/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.PureDaisyRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class PureDaisyRecipeCategory
implements IRecipeCategory<PureDaisyRecipe> {
    public static final RecipeType<PureDaisyRecipe> TYPE = RecipeType.create((String)"botania", (String)"pure_daisy", PureDaisyRecipe.class);
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final IPlatformFluidHelper fluidHelper;

    public PureDaisyRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<?> fluidHelper) {
        this.background = guiHelper.createBlankDrawable(96, 44);
        this.localizedName = Component.m_237115_((String)"botania.nei.pureDaisy");
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 44);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BotaniaFlowerBlocks.pureDaisy));
        this.fluidHelper = fluidHelper;
    }

    @NotNull
    public RecipeType<PureDaisyRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(PureDaisyRecipe recipe, IRecipeSlotsView slotsView, PoseStack ms, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(ms, 17, 0);
        RenderSystem.m_69461_();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull PureDaisyRecipe recipe, @NotNull IFocusGroup focusGroup) {
        StateIngredient input = recipe.getInput();
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 9, 12).setFluidRenderer(1000L, false, 16, 16);
        for (BlockState state : input.getDisplayed()) {
            if (state.m_60819_().m_76178_()) continue;
            inputSlotBuilder.addIngredient((IIngredientType)this.fluidHelper.getFluidIngredientType(), this.fluidHelper.create(state.m_60819_().m_76152_(), 1000L));
        }
        ((IRecipeSlotBuilder)inputSlotBuilder.addItemStacks(input.getDisplayedStacks())).addTooltipCallback((view, tooltip) -> tooltip.addAll(input.descriptionTooltip()));
        builder.addSlot(RecipeIngredientRole.CATALYST, 39, 12).addItemStack(new ItemStack((ItemLike)BotaniaFlowerBlocks.pureDaisy));
        Block outBlock = recipe.getOutputState().m_60734_();
        FluidState outFluid = outBlock.m_49966_().m_60819_();
        if (!outFluid.m_76178_()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 68, 12).setFluidRenderer(1000L, false, 16, 16).addIngredient((IIngredientType)this.fluidHelper.getFluidIngredientType(), this.fluidHelper.create(outFluid.m_76152_(), 1000L));
        } else if (outBlock.m_5456_() != Items.f_41852_) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 68, 12).addItemStack(new ItemStack((ItemLike)outBlock));
        }
    }
}

