/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.block_entity.BreweryBlockEntity;

public class BotanicalBreweryModel
extends Model {
    private static final ResourceLocation TEXTURE = new ResourceLocation("botania:textures/model/brewery.png");
    final ModelPart top;
    final ModelPart pole;
    final ModelPart bottom;
    final ModelPart plate;

    public BotanicalBreweryModel(ModelPart root) {
        super(RenderType::m_110446_);
        this.top = root.m_171324_("top");
        this.pole = root.m_171324_("pole");
        this.bottom = root.m_171324_("bottom");
        this.plate = root.m_171324_("plate");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171481_(-2.0f, -7.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        root.m_171599_("pole", CubeListBuilder.m_171558_().m_171481_(-1.0f, -6.0f, -1.0f, 2.0f, 10.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        root.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(8, 5).m_171481_(-2.0f, 4.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        root.m_171599_("plate", CubeListBuilder.m_171558_().m_171514_(8, 5).m_171481_(5.0f, 0.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        return mesh;
    }

    public void render(@Nullable BreweryBlockEntity brewery, double time, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float offset = (float)Math.sin(time / 40.0) * 0.1f + 0.05f;
        boolean hasTile = brewery != null;
        int plates = hasTile ? brewery.inventorySize() - 1 : 7;
        float deg = (float)time / 16.0f;
        float polerot = -deg * 25.0f;
        ms.m_85837_(0.0, (double)offset, 0.0);
        ms.m_85845_(Vector3f.f_122225_.m_122240_(polerot));
        if (hasTile && !brewery.getItemHandler().m_8020_(0).m_41619_()) {
            ms.m_85836_();
            ms.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            ms.m_85837_(0.0, (double)-0.45f, 0.0);
            this.renderItemStack(brewery.getItemHandler().m_8020_(0), ms, buffers, light, overlay);
            ms.m_85849_();
        }
        RenderType layer = this.m_103119_(TEXTURE);
        this.pole.m_104301_(ms, buffers.m_6299_(layer), light, overlay);
        this.top.m_104301_(ms, buffers.m_6299_(layer), light, overlay);
        this.bottom.m_104301_(ms, buffers.m_6299_(layer), light, overlay);
        ms.m_85845_(Vector3f.f_122225_.m_122240_(-polerot));
        float degper = (float)Math.PI * 2 / (float)plates;
        for (int i = 0; i < plates; ++i) {
            this.plate.f_104204_ = deg;
            float offset1 = (float)Math.sin(time / 20.0 + (double)((float)i * 40.0f)) * 0.2f - 0.2f;
            if (time == -1.0) {
                offset1 = 0.0f;
            }
            ms.m_85837_(0.0, (double)offset1, 0.0);
            if (hasTile && !brewery.getItemHandler().m_8020_(i + 1).m_41619_()) {
                float rot = this.plate.f_104204_ * 180.0f / (float)Math.PI;
                float transX = 0.3125f;
                float transY = 1.06f;
                float transZ = 0.1245f;
                ms.m_85836_();
                ms.m_85845_(Vector3f.f_122225_.m_122240_(rot));
                ms.m_85837_((double)transX, (double)transY, (double)transZ);
                ms.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                ms.m_85837_(0.125, 0.125, 0.0);
                this.renderItemStack(brewery.getItemHandler().m_8020_(i + 1), ms, buffers, light, overlay);
                ms.m_85849_();
            }
            this.plate.m_104301_(ms, buffers.m_6299_(layer), light, overlay);
            ms.m_85837_(0.0, (double)(-offset1), 0.0);
            deg += degper;
        }
        ms.m_85837_(0.0, (double)(-offset), 0.0);
    }

    private void renderItemStack(ItemStack stack, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        if (!stack.m_41619_()) {
            Minecraft mc = Minecraft.m_91087_();
            ms.m_85836_();
            float s = 0.25f;
            ms.m_85841_(s, s, s);
            mc.m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, light, overlay, ms, buffers, 0);
            ms.m_85849_();
        }
    }

    public void m_7695_(PoseStack ms, VertexConsumer buffer, int light, int overlay, float r, float g, float b, float a) {
        throw new UnsupportedOperationException("unimplemented, call using other render method");
    }
}

