/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.BabylonWeaponEntity;

public class BabylonWeaponRenderer
extends EntityRenderer<BabylonWeaponEntity> {
    public BabylonWeaponRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(@NotNull BabylonWeaponEntity weapon, float yaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light) {
        ms.m_85836_();
        ms.m_85845_(Vector3f.f_122225_.m_122240_(weapon.getRotation()));
        int live = weapon.getLiveTicks();
        int delay = weapon.getDelay();
        float charge = Math.min(10.0f, (float)Math.max(live, weapon.getChargeTicks()) + partialTicks);
        float chargeMul = charge / 10.0f;
        ms.m_85836_();
        ms.m_85837_(-0.75, 0.0, 1.0);
        float s = 1.5f;
        ms.m_85841_(s, s, s);
        ms.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        ms.m_85845_(Vector3f.f_122227_.m_122240_(-45.0f));
        BakedModel model = MiscellaneousModels.INSTANCE.kingKeyWeaponModels[weapon.getVariety()];
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(ms.m_85850_(), buffers.m_6299_(Sheets.m_110791_()), null, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_);
        ms.m_85849_();
        Random rand = new Random(weapon.m_20148_().getMostSignificantBits());
        ms.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        ms.m_85837_(0.0, (double)(-0.3f + rand.nextFloat() * 0.1f), 0.0);
        s = chargeMul;
        if (live > delay) {
            s -= Math.min(1.0f, ((float)(live - delay) + partialTicks) * 0.2f);
        }
        ms.m_85841_(s *= 2.0f, s, s);
        ms.m_85845_(Vector3f.f_122225_.m_122240_(charge * 9.0f + ((float)weapon.f_19797_ + partialTicks) * 0.5f + rand.nextFloat() * 360.0f));
        VertexConsumer buffer = buffers.m_6299_(RenderHelper.BABYLON_ICON);
        Matrix4f mat = ms.m_85850_().m_85861_();
        buffer.m_85982_(mat, -1.0f, 0.0f, -1.0f).m_85950_(1.0f, 1.0f, 1.0f, chargeMul).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_85982_(mat, -1.0f, 0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, chargeMul).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_85982_(mat, 1.0f, 0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, chargeMul).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_85982_(mat, 1.0f, 0.0f, -1.0f).m_85950_(1.0f, 1.0f, 1.0f, chargeMul).m_7421_(1.0f, 0.0f).m_5752_();
        ms.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BabylonWeaponEntity entity) {
        return InventoryMenu.f_39692_;
    }
}

