/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class ManaPumpBlockEntity
extends BotaniaBlockEntity {
    private static final String TAG_ACTIVE = "active";
    public float innerRingPos;
    private boolean active = false;
    public boolean hasCart = false;
    public boolean hasCartOnTop = false;
    public float moving = 0.0f;
    public int comparator;
    public boolean hasRedstone = false;
    private int lastComparator = 0;

    public ManaPumpBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.PUMP, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, ManaPumpBlockEntity self) {
        self.hasRedstone = level.m_46753_(worldPosition);
        float max = 8.0f;
        float min = 0.0f;
        float incr = max / 10.0f;
        if (self.innerRingPos < max && self.active && self.moving >= 0.0f) {
            self.innerRingPos += incr;
            self.moving = incr;
            if (self.innerRingPos >= max) {
                self.innerRingPos = Math.min(max, self.innerRingPos);
                self.moving = 0.0f;
                for (int x = 0; x < 2; ++x) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)worldPosition.m_123341_() + Math.random(), (double)worldPosition.m_123342_() + Math.random(), (double)worldPosition.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
                }
            }
        } else if (self.innerRingPos > min) {
            self.innerRingPos -= incr * 2.0f;
            self.moving = -incr * 2.0f;
            if (self.innerRingPos <= min) {
                self.innerRingPos = Math.max(min, self.innerRingPos);
                self.moving = 0.0f;
            }
        }
        if (!self.hasCartOnTop) {
            self.comparator = 0;
        }
        if (!self.hasCart && self.active) {
            self.setActive(false);
        }
        if (self.active && self.hasRedstone) {
            self.setActive(false);
        }
        self.hasCart = false;
        self.hasCartOnTop = false;
        if (self.comparator != self.lastComparator) {
            level.m_46717_(worldPosition, state.m_60734_());
        }
        self.lastComparator = self.comparator;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128379_(TAG_ACTIVE, this.active);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.active = cmp.m_128471_(TAG_ACTIVE);
    }

    public void setActive(boolean active) {
        if (!this.f_58857_.f_46443_) {
            boolean diff = this.active != active;
            this.active = active;
            if (diff) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
    }
}

