/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;

public class GourmaryllisBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_DIGESTING_MANA = "digestingMana";
    public static final String TAG_LAST_FOODS = "lastFoods";
    public static final String TAG_LAST_FOOD_COUNT = "lastFoodCount";
    public static final String TAG_STREAK_LENGTH = "streakLength";
    private static final int RANGE = 1;
    private static final double[] STREAK_MULTIPLIERS = new double[]{0.0, 1.0, 1.3, 1.5, 1.6, 1.7, 1.75, 1.8};
    private int cooldown = 0;
    private int digestingMana = 0;
    private final List<ItemStack> lastFoods = new LinkedList<ItemStack>();
    private int streakLength = -1;
    private int lastFoodCount = 0;

    public GourmaryllisBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.GOURMARYLLIS, pos, state);
    }

    private int getMaxStreak() {
        return STREAK_MULTIPLIERS.length - 1;
    }

    private double getMultiplierForStreak(int index) {
        if (index == 0) {
            return 1.0 / (double)(++this.lastFoodCount);
        }
        this.lastFoodCount = 1;
        return STREAK_MULTIPLIERS[index];
    }

    private int processFood(ItemStack food) {
        ListIterator<ItemStack> it = this.lastFoods.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            ItemStack streakFood = it.next();
            if (!streakFood.m_41656_(food) || !ItemStack.m_41658_((ItemStack)streakFood, (ItemStack)food)) continue;
            it.remove();
            this.lastFoods.add(0, streakFood);
            return index;
        }
        ItemStack newestFood = food.m_41777_();
        newestFood.m_41764_(1);
        this.lastFoods.add(0, newestFood);
        if (this.lastFoods.size() >= this.getMaxStreak()) {
            this.lastFoods.remove(this.lastFoods.size() - 1);
        }
        return this.getMaxStreak();
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.cooldown > -1) {
            --this.cooldown;
        }
        if (this.digestingMana != 0) {
            int munchInterval = 2 + 2 * this.lastFoodCount;
            if (this.cooldown == 0) {
                this.addMana(this.digestingMana);
                this.digestingMana = 0;
                float burpPitch = (float)Math.pow(2.0, (double)(this.streakLength == 0 ? -this.lastFoodCount : this.streakLength) / 12.0);
                this.m_58904_().m_5594_(null, this.getEffectivePos(), SoundEvents.f_12321_, SoundSource.BLOCKS, 1.0f, burpPitch);
                this.sync();
            } else if (this.cooldown % munchInterval == 0) {
                this.m_58904_().m_5594_(null, this.getEffectivePos(), SoundEvents.f_11912_, SoundSource.BLOCKS, 0.5f, 1.0f);
                Vec3 offset = this.m_58904_().m_8055_(this.getEffectivePos()).m_60824_((BlockGetter)this.m_58904_(), this.getEffectivePos()).m_82520_(0.4, 0.6, 0.4);
                ((ServerLevel)this.m_58904_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.lastFoods.get(0)), (double)this.getEffectivePos().m_123341_() + offset.f_82479_, (double)this.getEffectivePos().m_123342_() + offset.f_82480_, (double)this.getEffectivePos().m_123343_() + offset.f_82481_, 10, 0.1, 0.1, 0.1, 0.03);
            }
        }
        List items = this.m_58904_().m_45976_(ItemEntity.class, new AABB(this.getEffectivePos().m_7918_(-1, -1, -1), this.getEffectivePos().m_7918_(2, 2, 2)));
        for (ItemEntity item : items) {
            ItemStack stack = item.m_32055_();
            if (!DelayHelper.canInteractWithImmediate(this, item) || !stack.m_41720_().m_41472_()) continue;
            if (this.cooldown <= 0) {
                this.streakLength = Math.min(this.streakLength + 1, this.processFood(stack));
                int val = Math.min(12, stack.m_41720_().m_41473_().m_38744_());
                this.digestingMana = val * val * 70;
                this.digestingMana = (int)((double)this.digestingMana * this.getMultiplierForStreak(this.streakLength));
                this.cooldown = val * 10;
                item.m_5496_(SoundEvents.f_11912_, 0.2f, 0.6f);
                this.sync();
                ((ServerLevel)this.m_58904_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), item.m_20185_(), item.m_20186_(), item.m_20189_(), 20, 0.1, 0.1, 0.1, 0.05);
            }
            item.m_146870_();
        }
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_COOLDOWN, this.cooldown);
        cmp.m_128405_(TAG_DIGESTING_MANA, this.digestingMana);
        ListTag foodList = new ListTag();
        for (ItemStack food : this.lastFoods) {
            foodList.add((Object)food.m_41739_(new CompoundTag()));
        }
        cmp.m_128365_(TAG_LAST_FOODS, (Tag)foodList);
        cmp.m_128405_(TAG_LAST_FOOD_COUNT, this.lastFoodCount);
        cmp.m_128405_(TAG_STREAK_LENGTH, this.streakLength);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.m_128451_(TAG_COOLDOWN);
        this.digestingMana = cmp.m_128451_(TAG_DIGESTING_MANA);
        this.lastFoods.clear();
        ListTag foodList = cmp.m_128437_(TAG_LAST_FOODS, 10);
        for (int i = 0; i < foodList.size(); ++i) {
            this.lastFoods.add(ItemStack.m_41712_((CompoundTag)foodList.m_128728_(i)));
        }
        this.lastFoodCount = cmp.m_128451_(TAG_LAST_FOOD_COUNT);
        this.streakLength = cmp.m_128451_(TAG_STREAK_LENGTH);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 9000;
    }

    @Override
    public int getColor() {
        return 13882884;
    }
}

