/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.darkhax.botanypots.Constants;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BotanyPotVariantGenerator {
    public static File blockDir = BotanyPotVariantGenerator.makeDir("assets/botanypots/models/block");
    public static File itemDir = BotanyPotVariantGenerator.makeDir("assets/botanypots/models/item");
    public static File stateDir = BotanyPotVariantGenerator.makeDir("assets/botanypots/blockstates");
    public static File lootDir = BotanyPotVariantGenerator.makeDir("data/botanypots/loot_tables/blocks");
    public static File craftingDir = BotanyPotVariantGenerator.makeDir("data/botanypots/recipes/crafting");

    public static void generate() {
        BotanyPotVariantGenerator.generatePot(Blocks.f_50352_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50287_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50288_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50289_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50290_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50291_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50292_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50293_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50294_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50295_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50296_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50297_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50298_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50299_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50300_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50301_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50302_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50526_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50527_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50528_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50529_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50530_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50531_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50532_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50533_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50534_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50535_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50536_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50537_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50538_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50539_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50540_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50541_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50542_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50543_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50544_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50545_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50494_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50495_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50496_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50497_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50498_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50499_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50500_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50501_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50502_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50503_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50504_);
        BotanyPotVariantGenerator.generatePot(Blocks.f_50505_);
    }

    public static void generatePot(Block block) {
        try {
            ResourceLocation blockId = Registry.f_122824_.m_7981_((Object)block);
            Constants.LOG.info("botanypots:" + blockId.m_135815_() + "_botany_pot");
            Constants.LOG.info("botanypots:" + blockId.m_135815_() + "_hopper_botany_pot");
            BotanyPotVariantGenerator.generateBlockState(blockId, "botany_pot");
            BotanyPotVariantGenerator.generateBlockModel(blockId, "botany_pot", false);
            BotanyPotVariantGenerator.generateItemModel(blockId, "botany_pot");
            BotanyPotVariantGenerator.generateLootTable(blockId, "botany_pot");
            BotanyPotVariantGenerator.generateBasicCrafting(blockId);
            BotanyPotVariantGenerator.generateBlockState(blockId, "hopper_botany_pot");
            BotanyPotVariantGenerator.generateBlockModel(blockId, "hopper_botany_pot", true);
            BotanyPotVariantGenerator.generateItemModel(blockId, "hopper_botany_pot");
            BotanyPotVariantGenerator.generateLootTable(blockId, "hopper_botany_pot");
            BotanyPotVariantGenerator.generateHopperCrafting(blockId);
            BotanyPotVariantGenerator.generateCompactHopperCrafting(blockId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void generateCompactHopperCrafting(ResourceLocation blockId) throws IOException {
        String potId = "botanypots:" + blockId.m_135815_() + "_hopper_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, blockId.m_135815_() + "_compact_hopper_botany_pot.json"));){
            writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \"SHS\",\n        \"SPS\",\n        \" S \"\n    ],\n    \"key\": {\n        \"S\": {\n            \"item\": \"" + blockId.toString() + "\"\n        },\n        \"P\": {\n            \"item\": \"minecraft:flower_pot\"\n        },\n        \"H\": {\n            \"item\": \"minecraft:hopper\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
        }
    }

    public static void generateHopperCrafting(ResourceLocation blockId) throws IOException {
        String potId = "botanypots:" + blockId.m_135815_() + "_hopper_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, blockId.m_135815_() + "_hopper_botany_pot.json"));){
            writer.append("{\n    \"type\": \"minecraft:crafting_shapeless\",\n    \"ingredients\": [\n        {\n            \"item\": \"botanypots:" + blockId.m_135815_() + "_botany_pot\"\n        },\n        {\n            \"item\": \"minecraft:hopper\"\n        }\n    ],\n    \"result\": {\n        \"item\": \"" + potId + "\",\n        \"count\": 1\n    }\n}");
        }
    }

    public static void generateBasicCrafting(ResourceLocation blockId) throws IOException {
        String potId = "botanypots:" + blockId.m_135815_() + "_botany_pot";
        try (FileWriter writer = new FileWriter(new File(craftingDir, blockId.m_135815_() + "_botany_pot.json"));){
            writer.append("{\n    \"type\": \"crafting_shaped\",\n    \"pattern\": [\n        \"S S\",\n        \"SPS\",\n        \" S \"\n    ],\n    \"key\": {\n        \"S\": {\n            \"item\": \"" + blockId.toString() + "\"\n        },\n        \"P\": {\n            \"item\": \"minecraft:flower_pot\"\n        }\n    },\n    \"result\": {\n        \"item\": \"" + potId.toString() + "\",\n        \"count\": 1\n    }\n}");
        }
    }

    public static void generateLootTable(ResourceLocation blockId, String suffix) throws IOException {
        String potId = blockId.m_135815_() + "_" + suffix;
        try (FileWriter writer = new FileWriter(new File(lootDir, potId + ".json"));){
            writer.append("{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"functions\": [\n            {\n              \"function\": \"minecraft:copy_name\",\n              \"source\": \"block_entity\"\n            }\n          ],\n          \"name\": \"botanypots:" + potId + "\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ]\n}");
        }
    }

    public static void generateBlockState(ResourceLocation blockId, String suffix) throws IOException {
        String potId = blockId.m_135815_() + "_" + suffix;
        try (FileWriter writer = new FileWriter(new File(stateDir, potId + ".json"));){
            writer.append("{\n    \"variants\": {\n        \"\": {\n            \"model\": \"botanypots:block/" + potId + "\"\n        }\n    }\n}");
        }
    }

    public static void generateItemModel(ResourceLocation blockId, String suffix) throws IOException {
        String potId = blockId.m_135815_() + "_" + suffix;
        try (FileWriter writer = new FileWriter(new File(itemDir, potId + ".json"));){
            writer.append("{\n    \"parent\": \"botanypots:block/" + potId + "\"\n}");
        }
    }

    public static void generateBlockModel(ResourceLocation blockId, String suffix, boolean hopper) throws IOException {
        String potId = blockId.m_135815_() + "_" + suffix;
        String parent = hopper ? "hopper_botany_pot_base" : "botany_pot_base";
        try (FileWriter writer = new FileWriter(new File(blockDir, potId + ".json"));){
            writer.append("{\n    \"parent\": \"botanypots:block/" + parent + "\",\n    \"textures\": {\n        \"terracotta\": \"minecraft:block/" + blockId.m_135815_() + "\",\n        \"particle\": \"minecraft:block/" + blockId.m_135815_() + "\"\n    }\n}");
        }
    }

    private static File makeDir(String path) {
        File dir = new File(new File("datagen_out"), path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

