/*
 * Decompiled with CFR 0.152.
 */
package edivad.edivadlib.compat.top;

import edivad.edivadlib.compat.top.TOPElement;
import edivad.edivadlib.tools.utils.FluidUtils;
import java.text.DecimalFormat;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class FluidElement
extends TOPElement {
    protected final FluidStack fluid;
    protected final int capacity;
    protected final int colorLiquid;

    protected FluidElement(@NotNull FluidStack fluid, int capacity, int colorLiquid) {
        super(-16777216, 0xFFFFFF);
        this.fluid = fluid;
        this.capacity = capacity;
        this.colorLiquid = colorLiquid;
    }

    public FluidElement(@NotNull FluidStack fluid, int capacity, BlockEntity blockentity) {
        this(fluid, capacity, FluidUtils.getLiquidColorWithBiome(fluid, blockentity));
    }

    public FluidElement(FriendlyByteBuf buf) {
        this(buf.readFluidStack(), buf.readInt(), buf.readInt());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFluidStack(this.fluid);
        buf.writeInt(this.capacity);
        buf.writeInt(this.colorLiquid);
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.capacity == 0 || this.fluid.getAmount() == Integer.MAX_VALUE) {
            return level;
        }
        long fluidAmount = this.fluid.getAmount();
        long result = fluidAmount * (long)level / (long)this.capacity;
        return (int)result;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.fluid.isEmpty() ? null : FluidUtils.getFluidTexture(this.fluid);
    }

    @Override
    public MutableComponent getText() {
        String liquidText = this.fluid.isEmpty() ? "Empty" : this.fluid.getDisplayName().getString();
        DecimalFormat f = new DecimalFormat("#,##0");
        int amount = this.fluid.getAmount();
        return Component.m_237113_((String)String.format("%s: %smB", liquidText, f.format(amount)));
    }

    @Override
    protected boolean applyRenderColor() {
        FluidUtils.color(this.colorLiquid);
        return true;
    }
}

