/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.forgespi.Environment;
import top.seraphjack.simplelogin.command.arguments.EntryNameInput;
import top.seraphjack.simplelogin.server.storage.SLStorage;

public final class ArgumentTypeEntryName
implements ArgumentType<EntryNameInput> {
    private static final DynamicCommandExceptionType ENTRY_NOT_EXIST = new DynamicCommandExceptionType(o -> Component.m_237115_((String)"simplelogin.command.error.entry_not_found"));

    private ArgumentTypeEntryName() {
    }

    public static ArgumentTypeEntryName entryName() {
        return new ArgumentTypeEntryName();
    }

    public EntryNameInput parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readString();
        if (Environment.get().getDist() == Dist.DEDICATED_SERVER && !SLStorage.instance().storageProvider.registered(name)) {
            throw ENTRY_NOT_EXIST.create((Object)name);
        }
        return EntryNameInput.of(name);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSourceStack) {
            return SharedSuggestionProvider.m_82970_(SLStorage.instance().storageProvider.getAllRegisteredUsername(), (SuggestionsBuilder)builder);
        }
        Object object = context.getSource();
        if (object instanceof ClientSuggestionProvider) {
            ClientSuggestionProvider src = (ClientSuggestionProvider)object;
            return src.m_212155_(context);
        }
        return Suggestions.empty();
    }

    public static <S> String getEntryName(CommandContext<S> ctx, String name) {
        return ((EntryNameInput)ctx.getArgument(name, EntryNameInput.class)).getName();
    }
}

