/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.bloodchest;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.tileentity.bloodchest.IBloodChestRepairActionRegistry;
import org.cyclops.evilcraft.block.BlockBloodChestConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodChest;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;

public class RepairItemTickAction
implements ITickAction<BlockEntityBloodChest> {
    @Override
    public boolean canTick(BlockEntityBloodChest tile, ItemStack itemStack, int slot, int tick) {
        if (!tile.getTank().isEmpty() && !itemStack.m_41619_()) {
            IBloodChestRepairActionRegistry actions = (IBloodChestRepairActionRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBloodChestRepairActionRegistry.class);
            int actionID = actions.canRepair(itemStack, tick);
            return actionID >= 0;
        }
        return false;
    }

    private void drainTank(BlockEntityBloodChest tile, float usageMultiplier) {
        tile.getTank().drain((int)Math.ceil((float)BlockBloodChestConfig.mBPerDamage * usageMultiplier), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public void onTick(BlockEntityBloodChest tile, ItemStack itemStack, int slot, int tick) {
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick) && !tile.getTank().isEmpty() && !itemStack.m_41619_()) {
            itemStack = itemStack.m_41777_();
            IBloodChestRepairActionRegistry actions = (IBloodChestRepairActionRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBloodChestRepairActionRegistry.class);
            int actionID = actions.canRepair(itemStack, tick);
            if (actionID > -1) {
                float simulateMultiplier = ((Float)actions.repair(itemStack, tile.m_58904_().f_46441_, actionID, false, false).getLeft()).floatValue();
                if ((float)tile.getTank().getFluidAmount() >= (float)BlockBloodChestConfig.mBPerDamage * simulateMultiplier) {
                    Pair<Float, ItemStack> repairResult = actions.repair(itemStack, tile.m_58904_().f_46441_, actionID, true, false);
                    itemStack = (ItemStack)repairResult.getRight();
                    this.drainTank(tile, ((Float)repairResult.getLeft()).floatValue());
                }
            }
            tile.getInventory().m_6836_(slot, itemStack);
        }
    }

    @Override
    public float getRequiredTicks(BlockEntityBloodChest tile, int slot, int tick) {
        return BlockBloodChestConfig.ticksPerDamage;
    }
}

