/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;

public class BroomModifierRecipeAppendix
extends RecipeAppendix<RecipeBloodInfuser> {
    private static final int START_X_RESULT = 68;
    private static final AdvancedButtonEnum INPUT = AdvancedButtonEnum.create();
    private final BroomModifier modifier;
    private final List<Pair<ItemStack, Float>> modifierValues;

    public BroomModifierRecipeAppendix(IInfoBook infoBook, BroomModifier modifier, Map<ItemStack, Float> modifierValues) {
        super(infoBook, null);
        this.modifier = modifier;
        this.modifierValues = Lists.newArrayList();
        for (Map.Entry<ItemStack, Float> entry : modifierValues.entrySet()) {
            this.modifierValues.add((Pair<ItemStack, Float>)Pair.of((Object)entry.getKey(), (Object)entry.getValue()));
        }
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeightInner() {
        return 15;
    }

    protected String getUnlocalizedTitle() {
        return "broom.modifiers.evilcraft.type";
    }

    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawElementInner(ScreenInfoBook gui, PoseStack matrixStack, int x, int y, int width, int height, int page, int mx, int my) {
        int tick = this.getTick(gui);
        Pair<ItemStack, Float> value = this.modifierValues.get(tick % this.modifierValues.size());
        ItemStack input = (ItemStack)value.getKey();
        this.renderItem(gui, matrixStack, x, y, input, mx, my, INPUT);
        String line = String.format("+ %s %s", ((Float)value.getValue()).toString(), L10NHelpers.localize((String)this.modifier.getTranslationKey(), (Object[])new Object[0]));
        this.drawString(gui, matrixStack, line, x + 16 + 4, y + 3);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawString(ScreenInfoBook gui, PoseStack matrixStack, String string, int x, int y) {
        Font fontRenderer = gui.getFont();
        MultiLineLabel.m_94341_((Font)fontRenderer, (FormattedText)Component.m_237113_((String)string), (int)200).m_6508_(matrixStack, x, y, 9, 0);
    }
}

