/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.common.util.EnergyUtils;

public class FluxConfig {
    private static final Client CLIENT_CONFIG;
    private static final ForgeConfigSpec CLIENT_SPEC;
    private static final Common COMMON_CONFIG;
    private static final ForgeConfigSpec COMMON_SPEC;
    private static final Server SERVER_CONFIG;
    private static final ForgeConfigSpec SERVER_SPEC;
    public static boolean enableButtonSound;
    public static boolean enableGuiDebug;
    public static boolean enableOneProbeBasicInfo;
    public static boolean enableOneProbeAdvancedInfo;
    public static boolean enableOneProbeSneaking;
    public static boolean enableFluxRecipe;
    public static boolean enableChunkLoading;
    public static boolean enableSuperAdmin;
    public static long defaultLimit;
    public static long basicCapacity;
    public static long basicTransfer;
    public static long herculeanCapacity;
    public static long herculeanTransfer;
    public static long gargantuanCapacity;
    public static long gargantuanTransfer;
    public static int maximumPerPlayer;
    public static int superAdminRequiredPermission;

    static void init() {
        if (FMLEnvironment.dist.isClient()) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(FluxConfig::reload);
    }

    static void reload(@Nonnull ModConfigEvent event) {
        IConfigSpec spec = event.getConfig().getSpec();
        if (spec == CLIENT_SPEC) {
            CLIENT_CONFIG.load();
            FluxNetworks.LOGGER.debug("Client config loaded");
        } else if (spec == COMMON_SPEC) {
            COMMON_CONFIG.load();
            FluxNetworks.LOGGER.debug("Common config loaded");
        } else if (spec == SERVER_SPEC) {
            SERVER_CONFIG.load();
            FluxNetworks.LOGGER.debug("Server config loaded");
        }
    }

    static {
        ForgeConfigSpec.Builder builder;
        if (FMLEnvironment.dist.isClient()) {
            builder = new ForgeConfigSpec.Builder();
            CLIENT_CONFIG = new Client(builder);
            CLIENT_SPEC = builder.build();
        } else {
            CLIENT_CONFIG = null;
            CLIENT_SPEC = null;
        }
        builder = new ForgeConfigSpec.Builder();
        COMMON_CONFIG = new Common(builder);
        COMMON_SPEC = builder.build();
        builder = new ForgeConfigSpec.Builder();
        SERVER_CONFIG = new Server(builder);
        SERVER_SPEC = builder.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private final ForgeConfigSpec.BooleanValue mEnableButtonSound;
        private final ForgeConfigSpec.BooleanValue mEnableGuiDebug;

        private Client(@Nonnull ForgeConfigSpec.Builder builder) {
            builder.push("gui");
            this.mEnableButtonSound = builder.comment("Enable navigation buttons sound when pressing it").translation("fluxnetworks.config.enableButtonSound").define("enableButtonSound", true);
            this.mEnableGuiDebug = builder.comment("Enable Modern UI").define("enableGuiDebug", false);
            builder.pop();
        }

        private void load() {
            enableButtonSound = (Boolean)this.mEnableButtonSound.get();
            enableGuiDebug = (Boolean)this.mEnableGuiDebug.get();
        }
    }

    private static class Common {
        private final ForgeConfigSpec.BooleanValue mEnableOneProbeBasicInfo;
        private final ForgeConfigSpec.BooleanValue mEnableOneProbeAdvancedInfo;
        private final ForgeConfigSpec.BooleanValue mEnableOneProbeSneaking;

        private Common(@Nonnull ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"Most configs are moved to /serverconfig/fluxnetworks-server.toml", "Copy to /defaultconfig/fluxnetworks-server.toml for modpacks"}).define("placeholder", true);
            builder.comment("The One Probe").push("OneProbe");
            this.mEnableOneProbeBasicInfo = builder.comment("Displays: Network Name, Live Transfer Rate & Internal Buffer").translation("fluxnetworks.config.enableOneProbeBasicInfo").define("enableOneProbeBasicInfo", true);
            this.mEnableOneProbeAdvancedInfo = builder.comment("Displays: Transfer Limit & Priority etc").translation("fluxnetworks.config.enableOneProbeAdvancedInfo").define("enableOneProbeAdvancedInfo", true);
            this.mEnableOneProbeSneaking = builder.comment("Displays Advanced Info when sneaking only").translation("fluxnetworks.config.enableOneProbeSneaking").define("enableOneProbeSneaking", true);
            builder.pop();
        }

        private void load() {
            enableOneProbeBasicInfo = (Boolean)this.mEnableOneProbeBasicInfo.get();
            enableOneProbeAdvancedInfo = (Boolean)this.mEnableOneProbeAdvancedInfo.get();
            enableOneProbeSneaking = (Boolean)this.mEnableOneProbeSneaking.get();
        }
    }

    private static class Server {
        private final ForgeConfigSpec.IntValue mMaximumPerPlayer;
        private final ForgeConfigSpec.IntValue mSuperAdminRequiredPermission;
        private final ForgeConfigSpec.BooleanValue mEnableSuperAdmin;
        private final ForgeConfigSpec.BooleanValue mEnableFluxRecipe;
        private final ForgeConfigSpec.BooleanValue mEnableChunkLoading;
        private final ForgeConfigSpec.ConfigValue<List<String>> mBlockBlacklistStrings;
        private final ForgeConfigSpec.ConfigValue<List<String>> mItemBlackListStrings;
        private final ForgeConfigSpec.LongValue mDefaultLimit;
        private final ForgeConfigSpec.LongValue mBasicCapacity;
        private final ForgeConfigSpec.LongValue mBasicTransfer;
        private final ForgeConfigSpec.LongValue mHerculeanCapacity;
        private final ForgeConfigSpec.LongValue mHerculeanTransfer;
        private final ForgeConfigSpec.LongValue mGargantuanCapacity;
        private final ForgeConfigSpec.LongValue mGargantuanTransfer;

        private Server(@Nonnull ForgeConfigSpec.Builder builder) {
            builder.push("networks");
            this.mMaximumPerPlayer = builder.comment(new String[]{"Maximum networks each player can have. Super admin can bypass this limit. -1 = no limit", "Setting this to 0 will only allow super admins to create networks."}).translation("fluxnetworks.config.maximumPerPlayer").defineInRange("maximumPerPlayer", 5, -1, Integer.MAX_VALUE);
            this.mEnableSuperAdmin = builder.comment("Allows someone to be a network super admin. Otherwise, no one can access a flux device or delete a network without permission.").translation("fluxnetworks.config.enableSuperAdmin").define("enableSuperAdmin", true);
            this.mSuperAdminRequiredPermission = builder.comment(new String[]{"See ops.json. If the player has permission level equal or greater to the value set here they will be able to activate Super Admin.", "Setting this to 0 will allow anyone to active Super Admin. Single player can bypass this limit.", "Players have permission level 3 or 4 can use commands to set others as Super Admin whether others have this permission level or not."}).translation("fluxnetworks.config.superAdminRequiredPermission").defineInRange("superAdminRequiredPermission", 1, 0, 3);
            builder.pop();
            builder.push("general");
            this.mEnableFluxRecipe = builder.comment("Enables redstone being compressed with the bedrock and obsidian to get flux dusts.").translation("fluxnetworks.config.enableFluxRecipe").define("enableFluxRecipe", true);
            this.mEnableChunkLoading = builder.comment("Allows flux devices to enable chunk loading.").translation("fluxnetworks.config.enableChunkLoading").define("enableChunkLoading", true);
            builder.pop();
            builder.push("blacklist");
            this.mBlockBlacklistStrings = builder.comment("A blacklist for blocks which flux devices shouldn't connect to, use format 'modid:registry_name'").translation("fluxnetworks.config.blockBlacklistStrings").define("blockBlacklistStrings", (Object)Lists.newArrayList((Object[])new String[]{"actuallyadditions:block_phantom_energyface"}));
            this.mItemBlackListStrings = builder.comment("A blacklist for items which wireless charging shouldn't charge to, use format 'modid:registry_name'").translation("fluxnetworks.config.itemBlackListStrings").define("itemBlackListStrings", (Object)Lists.newArrayList((Object[])new String[]{""}));
            builder.pop();
            builder.push("energy");
            this.mDefaultLimit = builder.comment("The default transfer limit of a Flux Plug, Point and Controller").translation("fluxnetworks.config.defaultLimit").defineInRange("defaultLimit", 800000L, 0L, Long.MAX_VALUE);
            this.mBasicCapacity = builder.comment("The maximum energy storage of a Basic Flux Storage").translation("fluxnetworks.config.basicCapacity").defineInRange("basicCapacity", 2000000L, 0L, Long.MAX_VALUE);
            this.mBasicTransfer = builder.comment("The default transfer limit of a Basic Flux Storage").translation("fluxnetworks.config.basicTransfer").defineInRange("basicTransfer", 20000L, 0L, Long.MAX_VALUE);
            this.mHerculeanCapacity = builder.comment("The maximum energy storage of a Herculean Flux Storage").translation("fluxnetworks.config.herculeanCapacity").defineInRange("herculeanCapacity", 16000000L, 0L, Long.MAX_VALUE);
            this.mHerculeanTransfer = builder.comment("The default transfer limit of a Herculean Flux Storage").translation("fluxnetworks.config.herculeanTransfer").defineInRange("herculeanTransfer", 120000L, 0L, Long.MAX_VALUE);
            this.mGargantuanCapacity = builder.comment("The maximum energy storage of a Gargantuan Flux Storage").translation("fluxnetworks.config.gargantuanCapacity").defineInRange("gargantuanCapacity", 128000000L, 0L, Long.MAX_VALUE);
            this.mGargantuanTransfer = builder.comment("The default transfer limit of a Gargantuan Flux Storage").translation("fluxnetworks.config.gargantuanTransfer").defineInRange("gargantuanTransfer", 720000L, 0L, Long.MAX_VALUE);
            builder.pop();
        }

        private void load() {
            maximumPerPlayer = (Integer)this.mMaximumPerPlayer.get();
            superAdminRequiredPermission = (Integer)this.mSuperAdminRequiredPermission.get();
            enableFluxRecipe = (Boolean)this.mEnableFluxRecipe.get();
            enableChunkLoading = (Boolean)this.mEnableChunkLoading.get();
            enableSuperAdmin = (Boolean)this.mEnableSuperAdmin.get();
            EnergyUtils.reloadBlacklist((List)this.mBlockBlacklistStrings.get(), (List)this.mItemBlackListStrings.get());
            defaultLimit = (Long)this.mDefaultLimit.get();
            basicCapacity = (Long)this.mBasicCapacity.get();
            basicTransfer = (Long)this.mBasicTransfer.get();
            herculeanCapacity = (Long)this.mHerculeanCapacity.get();
            herculeanTransfer = (Long)this.mHerculeanTransfer.get();
            gargantuanCapacity = (Long)this.mGargantuanCapacity.get();
            gargantuanTransfer = (Long)this.mGargantuanTransfer.get();
        }
    }
}

