/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.energy.EnergyType;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopupHost;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.integration.MUIIntegration;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.ClientMessages;

public abstract class GuiFluxCore
extends GuiPopupHost {
    protected final List<GuiButtonCore> mButtons = new ArrayList<GuiButtonCore>();
    public final Player mPlayer;
    private FluxNetwork mNetwork;

    public GuiFluxCore(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
        this.mPlayer = player;
        this.mNetwork = ClientCache.getNetwork(menu.mProvider.getNetworkID());
        menu.mOnResultListener = this::onResponse;
    }

    private void onResponse(FluxMenu menu, int key, int code) {
        FluxTranslate t = FluxTranslate.fromResponseCode(code);
        if (t != null) {
            if (FluxNetworks.isModernUILoaded()) {
                MUIIntegration.showToastError(t);
            } else {
                this.getMinecraft().m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)this.getMinecraft(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237113_((String)"Flux Networks"), (Component)t.getComponent()));
            }
        }
        this.onResponseAction(key, code);
    }

    public int getToken() {
        return ((FluxMenu)this.f_97732_).f_38840_;
    }

    @Nonnull
    public FluxNetwork getNetwork() {
        return this.mNetwork;
    }

    @Nonnull
    public AccessLevel getAccessLevel() {
        return this.mNetwork.getPlayerAccess(this.mPlayer);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.mButtons.clear();
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY, deltaTicks);
        for (GuiButtonCore button : this.mButtons) {
            button.drawButton(poseStack, mouseX, mouseY, deltaTicks);
        }
    }

    @Override
    protected void drawBackgroundLayer(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
        super.drawBackgroundLayer(poseStack, mouseX, mouseY, deltaTicks);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.blitBackgroundOrFrame(poseStack);
        int color = this.mNetwork.getNetworkColor();
        RenderSystem.m_157429_((float)FluxUtils.getRed(color), (float)FluxUtils.getGreen(color), (float)FluxUtils.getBlue(color), (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)FRAME);
        this.blitBackgroundOrFrame(poseStack);
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (GuiButtonCore button : this.mButtons) {
            if (!button.mClickable || !button.isMouseHovered(mouseX, mouseY)) continue;
            this.onButtonClicked(button, (float)mouseX, (float)mouseY, mouseButton);
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        this.mNetwork = ClientCache.getNetwork(((FluxMenu)this.f_97732_).mProvider.getNetworkID());
    }

    public void m_7379_() {
        super.m_7379_();
    }

    protected void renderNetwork(PoseStack poseStack, String name, int color, int y) {
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)FluxUtils.getRed(color), (float)FluxUtils.getGreen(color), (float)FluxUtils.getBlue(color), (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON);
        int x = this.f_97735_ + 20;
        this.blitF(poseStack, x, y, 135.0f, 12.0f, 0.0f, 320.0f, 270.0f, 24.0f);
        this.f_96547_.m_92883_(poseStack, name, (float)(x + 4), (float)(y + 2), 0xFFFFFF);
    }

    protected void renderTransfer(PoseStack poseStack, IFluxDevice device, int x, int y) {
        RenderSystem.m_69478_();
        this.f_96547_.m_92883_(poseStack, FluxUtils.getTransferInfo(device, EnergyType.FE), (float)x, (float)y, 0xFFFFFF);
        Object text = device.getDeviceType().isStorage() ? FluxTranslate.ENERGY.get() : FluxTranslate.BUFFER.get();
        text = (String)text + ": " + ChatFormatting.BLUE + EnergyType.FE.getStorage(device.getTransferBuffer());
        this.f_96547_.m_92883_(poseStack, (String)text, (float)x, (float)(y + 10), 0xFFFFFF);
        this.renderItemStack(device.getDisplayStack(), x - 20, y + 1);
    }

    protected void renderItemStack(ItemStack stack, int x, int y) {
        this.m_93250_(50);
        this.f_96542_.f_115093_ = 50.0f;
        this.f_96542_.m_115203_(stack, x, y);
        this.m_93250_(0);
        this.f_96542_.f_115093_ = 0.0f;
    }

    public void setConnectedNetwork(FluxNetwork network, String password) {
        if (((FluxMenu)this.f_97732_).mProvider instanceof TileFluxDevice) {
            ClientMessages.tileNetwork(this.getToken(), (TileFluxDevice)((FluxMenu)this.f_97732_).mProvider, network, password);
        } else if (((FluxMenu)this.f_97732_).mProvider instanceof ItemAdminConfigurator.Provider) {
            ClientCache.sAdminViewingNetwork = network.getNetworkID();
        }
    }

    protected void onResponseAction(int key, int code) {
    }
}

