/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.common.device.TileFluxDevice;

public class TransferIterator
implements Iterator<TileFluxDevice> {
    private final boolean mPoint;
    private Iterator<TileFluxDevice> mIterator;
    private TileFluxDevice mNext;

    public TransferIterator(boolean point) {
        this.mPoint = point;
    }

    public TransferIterator reset(@Nonnull List<TileFluxDevice> list) {
        this.mIterator = list.iterator();
        this.mNext = this.mIterator.hasNext() ? this.mIterator.next() : null;
        return this;
    }

    public boolean increment() {
        if (this.mIterator.hasNext()) {
            this.mNext = this.mIterator.next();
            return this.needTransfer() || this.increment();
        }
        this.mNext = null;
        return false;
    }

    private boolean needTransfer() {
        if (this.mPoint) {
            return this.mNext.getTransferHandler().getRequest() > 0L;
        }
        return this.mNext.getTransferHandler().getBuffer() > 0L;
    }

    @Override
    public boolean hasNext() {
        if (this.mNext == null) {
            return false;
        }
        return this.needTransfer() || this.increment();
    }

    @Override
    public TileFluxDevice next() {
        return this.mNext;
    }
}

