/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.interactive.FramedLargeButtonBlock;

public class FramedLargeButtonModel
extends FramedBlockModel {
    protected final Direction dir;
    protected final AttachFace face;
    protected final Direction facing;
    protected final boolean pressed;

    public FramedLargeButtonModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        this.face = (AttachFace)state.m_61143_((Property)BlockStateProperties.f_61376_);
        this.facing = FramedLargeButtonModel.getFacing(this.dir, this.face);
        this.pressed = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(this.facing)) {
            this.generateVerticalButton(quadMap, quad, quadDir);
        } else {
            this.generateHorizontalButton(quadMap, quad, quadDir);
        }
    }

    private void generateVerticalButton(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction quadDir) {
        if (quadDir.m_122434_() == this.facing.m_122434_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.0625f, 0.0625f, 0.9375f, 0.9375f)).applyIf(Modifiers.setPosition(this.pressed ? 0.0625f : 0.125f), quadDir == this.facing).export(quadMap.get(quadDir == this.facing ? null : quadDir));
        } else {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, this.pressed ? 0.0625f : 0.125f)).apply(Modifiers.cutSideLeftRight(0.9375f)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        }
    }

    private void generateHorizontalButton(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction quadDir) {
        float height;
        float f = height = this.pressed ? 0.0625f : 0.125f;
        if (quadDir.m_122434_() == this.facing.m_122434_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.0625f, 0.0625f, 0.9375f, 0.9375f)).applyIf(Modifiers.setPosition(height), quadDir == this.facing).export(quadMap.get(quadDir == this.facing ? null : quadDir));
        } else if (Utils.isY(quadDir)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir, height)).apply(Modifiers.cutTopBottom(this.dir.m_122427_().m_122434_(), 0.9375f)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        } else {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir, height)).apply(Modifiers.cutSideUpDown(0.9375f)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        }
    }

    private static Direction getFacing(Direction dir, AttachFace face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> Direction.UP;
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.WALL -> dir;
        };
    }

    public static BlockState mergeStates(BlockState state) {
        AttachFace face = (AttachFace)state.m_61143_((Property)FramedLargeButtonBlock.f_53179_);
        if (face == AttachFace.WALL) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)FramedLargeButtonBlock.f_54117_, (Comparable)Direction.NORTH);
    }
}

