/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.gateways.Gateways;
import shadows.gateways.codec.GatewayCodecs;
import shadows.gateways.entity.GatewayEntity;
import shadows.placebo.codec.PlaceboCodecs;
import shadows.placebo.json.NBTAdapter;

public interface Failure
extends PlaceboCodecs.CodecProvider<Failure> {
    public static final BiMap<ResourceLocation, Codec<? extends Failure>> CODECS = HashBiMap.create();
    public static final Codec<Failure> CODEC = GatewayCodecs.mapBacked("Gateway Failure", CODECS);

    public void onFailure(ServerLevel var1, GatewayEntity var2, Player var3, GatewayEntity.FailureReason var4);

    public void appendHoverText(Consumer<Component> var1);

    public static void initSerializers() {
        Failure.register("explosion", ExplosionFailure.CODEC);
        Failure.register("mob_effect", MobEffectFailure.CODEC);
        Failure.register("summon", SummonFailure.CODEC);
        Failure.register("chanced", ChancedFailure.CODEC);
        Failure.register("command", CommandFailure.CODEC);
    }

    private static void register(String id, Codec<? extends Failure> codec) {
        CODECS.put((Object)Gateways.loc(id), codec);
    }

    public record ExplosionFailure(float strength, boolean fire, boolean blockDamage) implements Failure
    {
        public static Codec<ExplosionFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("strength").forGetter(ExplosionFailure::strength), (App)Codec.BOOL.fieldOf("fire").forGetter(ExplosionFailure::fire), (App)Codec.BOOL.fieldOf("block_damage").forGetter(ExplosionFailure::blockDamage)).apply((Applicative)inst, ExplosionFailure::new));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            level.m_46518_((Entity)gate, gate.m_20185_(), gate.m_20186_(), gate.m_20189_(), this.strength, this.fire, this.blockDamage ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237110_((String)"failure.gateways.explosion", (Object[])new Object[]{Float.valueOf(this.strength), this.fire, this.blockDamage}));
        }
    }

    public record MobEffectFailure(MobEffect effect, int duration, int amplifier) implements Failure
    {
        public static Codec<MobEffectFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("effect").forGetter(MobEffectFailure::effect), (App)Codec.INT.fieldOf("duration").forGetter(MobEffectFailure::duration), (App)Codec.INT.fieldOf("amplifier").forGetter(MobEffectFailure::amplifier)).apply((Applicative)inst, MobEffectFailure::new));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            level.m_45955_(TargetingConditions.m_148353_(), null, gate.m_20191_().m_82400_(gate.getGateway().leashRange)).forEach(p -> p.m_7292_(new MobEffectInstance(this.effect, this.duration, this.amplifier)));
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237110_((String)"failure.gateways.mob_effect", (Object[])new Object[]{MobEffectFailure.toComponent(new MobEffectInstance(this.effect, this.duration, this.amplifier))}));
        }

        private static Component toComponent(MobEffectInstance mobeffectinstance) {
            MutableComponent mutablecomponent = Component.m_237115_((String)mobeffectinstance.m_19576_());
            MobEffect mobeffect = mobeffectinstance.m_19544_();
            if (mobeffectinstance.m_19564_() > 0) {
                mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + mobeffectinstance.m_19564_()))});
            }
            if (mobeffectinstance.m_19557_() > 20) {
                mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_19581_((MobEffectInstance)mobeffectinstance, (float)1.0f)});
            }
            return mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_());
        }
    }

    public record SummonFailure(EntityType<?> type, @Nullable CompoundTag nbt, int count) implements Failure
    {
        public static Codec<SummonFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ENTITY_TYPES.getCodec().fieldOf("entity").forGetter(SummonFailure::type), (App)NBTAdapter.EITHER_CODEC.optionalFieldOf("nbt").forGetter(f -> Optional.ofNullable(f.nbt)), (App)Codec.INT.fieldOf("count").forGetter(SummonFailure::count)).apply((Applicative)inst, (type, nbt, count) -> new SummonFailure((EntityType<?>)type, nbt.orElse(null), (int)count)));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            for (int i = 0; i < this.count; ++i) {
                Entity entity = this.type.m_20615_((Level)level);
                if (this.nbt != null) {
                    entity.m_20258_(this.nbt);
                }
                entity.m_7678_(gate.m_20185_(), gate.m_20186_(), gate.m_20189_(), 0.0f, 0.0f);
                level.m_7967_(entity);
            }
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237110_((String)"failure.gateways.summon", (Object[])new Object[]{this.count, Component.m_237115_((String)this.type.m_20675_())}));
        }
    }

    public record ChancedFailure(Failure failure, float chance) implements Failure
    {
        public static Codec<ChancedFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.fieldOf("failure").forGetter(ChancedFailure::failure), (App)Codec.FLOAT.fieldOf("chance").forGetter(ChancedFailure::chance)).apply((Applicative)inst, ChancedFailure::new));
        static DecimalFormat fmt = new DecimalFormat("##.##%");

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            if (level.f_46441_.m_188501_() < this.chance) {
                this.failure.onFailure(level, gate, summoner, reason);
            }
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            this.failure.appendHoverText(c -> list.accept((Component)Component.m_237110_((String)"failure.gateways.chance", (Object[])new Object[]{fmt.format(this.chance * 100.0f), c})));
        }
    }

    public record CommandFailure(String command, String desc) implements Failure
    {
        public static Codec<CommandFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("command").forGetter(CommandFailure::command), (App)Codec.STRING.fieldOf("desc").forGetter(CommandFailure::desc)).apply((Applicative)inst, CommandFailure::new));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            String realCmd = this.command.replace("<summoner>", summoner.m_36316_().getName());
            level.m_7654_().m_129892_().m_230957_(gate.m_20203_(), realCmd);
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Consumer<Component> list) {
            list.accept((Component)Component.m_237115_((String)this.desc));
        }
    }
}

