/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.ArcRecyclingChecker;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class ArcRecyclingCalculator {
    private final List<Recipe<?>> recipeList;
    private final long startTime;
    private final ArcRecyclingChecker checker;
    private final RegistryAccess tags;

    public ArcRecyclingCalculator(Collection<Recipe<?>> allRecipes, RegistryAccess tags) {
        this.tags = tags;
        this.startTime = System.currentTimeMillis();
        Pair<Predicate<Recipe<?>>, ArcRecyclingChecker> pair = ArcRecyclingChecker.assembleRecyclingFilter(tags);
        this.checker = (ArcRecyclingChecker)pair.getSecond();
        this.recipeList = allRecipes.stream().filter((Predicate)pair.getFirst()).collect(Collectors.toList());
    }

    public List<ArcFurnaceRecipe> run() {
        RecipeIterator iterator = new RecipeIterator(this.recipeList, this.checker, this.tags);
        iterator.process();
        int timeout = 0;
        while (!iterator.nonValidated.isEmpty() && timeout++ < iterator.invalidCount * 10) {
            ArrayList<RecyclingCalculation> newlyValid = new ArrayList<RecyclingCalculation>();
            for (RecyclingCalculation valid : iterator.validated) {
                for (ItemStack key : iterator.nonValidated.keySet()) {
                    if (!ItemStack.m_41746_((ItemStack)key, (ItemStack)valid.stack)) continue;
                    for (RecyclingCalculation nonValid : iterator.nonValidated.get((Object)key)) {
                        if (!nonValid.validateSubcomponent(valid)) continue;
                        newlyValid.add(nonValid);
                    }
                }
            }
            if (newlyValid.isEmpty()) break;
            iterator.nonValidated.values().removeAll(newlyValid);
            iterator.validated.addAll(newlyValid);
        }
        ArrayList<ArcFurnaceRecipe> generatedRecipes = new ArrayList<ArcFurnaceRecipe>();
        HashSet<String> finishedRecycles = new HashSet<String>();
        for (RecyclingCalculation valid : iterator.validated) {
            if (!finishedRecycles.add(valid.stack.toString()) || valid.outputs.isEmpty()) continue;
            generatedRecipes.add(this.makeRecipe(valid));
        }
        for (RecyclingCalculation invalid : Sets.newHashSet((Iterable)iterator.nonValidated.values())) {
            if (!finishedRecycles.add(invalid.stack.toString()) || invalid.outputs.isEmpty()) continue;
            IELogger.info("Couldn't fully analyze " + invalid.stack + ", missing knowledge for " + invalid.queriedSubcomponents);
            generatedRecipes.add(this.makeRecipe(invalid));
        }
        IELogger.info("Finished recipe profiler for Arc Recycling, took " + (System.currentTimeMillis() - this.startTime) + " milliseconds");
        return generatedRecipes;
    }

    public static Mutable<List<ArcFurnaceRecipe>> makeFuture() {
        MutableObject result = new MutableObject();
        MutableObject eventListener = new MutableObject();
        eventListener.setValue(new Object((Mutable)result, (Mutable)eventListener){
            final /* synthetic */ Mutable val$result;
            final /* synthetic */ Mutable val$eventListener;
            {
                this.val$result = mutable;
                this.val$eventListener = mutable2;
            }

            @SubscribeEvent
            public void onServerStarted(ServerStartedEvent ev) {
                this.fillInRecipes(ev.getServer());
            }

            @SubscribeEvent
            public void onServerTick(TickEvent.ServerTickEvent ev) {
                this.fillInRecipes(ServerLifecycleHooks.getCurrentServer());
            }

            private void fillInRecipes(MinecraftServer server) {
                Preconditions.checkState((this.val$result.getValue() == null ? 1 : 0) != 0);
                Collection recipes = server.m_129894_().m_44051_();
                ArcRecyclingCalculator calculator = new ArcRecyclingCalculator(recipes, (RegistryAccess)server.m_206579_());
                this.val$result.setValue(calculator.run());
                MinecraftForge.EVENT_BUS.unregister(this.val$eventListener.getValue());
            }
        });
        MinecraftForge.EVENT_BUS.register(eventListener.getValue());
        return result;
    }

    private ArcRecyclingRecipe makeRecipe(RecyclingCalculation calculation) {
        ResourceLocation id = new ResourceLocation("immersiveengineering", "recycling/" + ForgeRegistries.ITEMS.getKey((Object)calculation.stack.m_41720_()).m_135815_());
        return new ArcRecyclingRecipe(id, () -> this.tags, calculation.outputs.entrySet().stream().map(e -> Pair.of((Object)Lazy.of(e::getKey), (Object)((Double)e.getValue()))).toList(), IngredientWithSize.of(calculation.stack), 100, 51200);
    }

    private static class RecipeIterator {
        final List<Recipe<?>> recipeList;
        final List<RecyclingCalculation> validated = new ArrayList<RecyclingCalculation>();
        final Multimap<ItemStack, RecyclingCalculation> nonValidated = ArrayListMultimap.create();
        private final ArcRecyclingChecker checker;
        int invalidCount = 0;
        private final RegistryAccess tags;

        public RecipeIterator(List<Recipe<?>> recipeList, ArcRecyclingChecker checker, RegistryAccess tags) {
            this.recipeList = recipeList;
            this.checker = checker;
            this.tags = tags;
        }

        public void process() {
            for (Recipe<?> recipe : this.recipeList) {
                RecyclingCalculation calc = this.getRecycleCalculation(recipe.m_8043_(), recipe);
                if (calc == null) continue;
                if (calc.isValid()) {
                    this.validated.add(calc);
                    continue;
                }
                for (ItemStack s : calc.queriedSubcomponents.keySet()) {
                    this.nonValidated.put((Object)s, (Object)calc);
                }
                ++this.invalidCount;
            }
        }

        private RecyclingCalculation getRecycleCalculation(ItemStack stack, Recipe<?> recipe) {
            Pair<ItemStack, Double> brokenDown = ApiUtils.breakStackIntoPreciseIngots(this.tags, stack);
            if (brokenDown != null && ArcRecyclingChecker.isValidRecyclingOutput(this.tags, (ItemStack)brokenDown.getFirst()) && (Double)brokenDown.getSecond() > 0.0) {
                return new RecyclingCalculation(recipe, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1), (Map<ItemStack, Double>)ImmutableMap.of((Object)((ItemStack)brokenDown.getFirst()), (Object)((Double)brokenDown.getSecond())));
            }
            NonNullList inputs = recipe.m_7527_();
            if (!inputs.isEmpty()) {
                int resultCount = stack.m_41613_();
                HashMap<ItemStack, Integer> missingSub = new HashMap<ItemStack, Integer>();
                IdentityHashMap<ItemStack, Double> outputs = new IdentityHashMap<ItemStack, Double>();
                for (Object in : inputs) {
                    boolean invalidOutput;
                    if (in == null || in == Ingredient.f_43901_) continue;
                    ItemStack[] itemStackArray = in.m_43908_();
                    ItemStack inputStack = ItemStack.f_41583_;
                    if (itemStackArray.length > 0) {
                        inputStack = IEApi.getPreferredStackbyMod(in.m_43908_());
                    }
                    if (inputStack.m_41619_()) {
                        IELogger.warn("Recipe has invalid inputs and will be ignored: " + recipe + " (" + recipe.m_6423_() + ")");
                        return null;
                    }
                    brokenDown = ApiUtils.breakStackIntoPreciseIngots(this.tags, inputStack);
                    if (brokenDown == null) {
                        if (!this.checker.isAllowed(this.tags, inputStack) || !ArcRecyclingChecker.isValidRecyclingOutput(this.tags, inputStack)) continue;
                        boolean b = false;
                        for (ItemStack storedMiss : missingSub.keySet()) {
                            if (!ItemStack.m_41746_((ItemStack)inputStack, (ItemStack)storedMiss)) continue;
                            missingSub.put(storedMiss, (Integer)missingSub.get(storedMiss) + inputStack.m_41613_());
                            b = true;
                        }
                        if (b) continue;
                        missingSub.put(ItemHandlerHelper.copyStackWithSize((ItemStack)inputStack, (int)1), inputStack.m_41613_());
                        continue;
                    }
                    if (((ItemStack)brokenDown.getFirst()).m_41619_() || !((Double)brokenDown.getSecond() > 0.0) || (invalidOutput = !ArcRecyclingChecker.isValidRecyclingOutput(this.tags, (ItemStack)brokenDown.getFirst()))) continue;
                    boolean b = false;
                    for (ItemStack storedOut : outputs.keySet()) {
                        if (!ItemStack.m_41746_((ItemStack)((ItemStack)brokenDown.getFirst()), (ItemStack)storedOut)) continue;
                        outputs.put(storedOut, (Double)outputs.get(storedOut) + (Double)brokenDown.getSecond());
                        b = true;
                    }
                    if (b) continue;
                    outputs.put(ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)brokenDown.getFirst()), (int)1), (Double)brokenDown.getSecond());
                }
                IdentityHashMap<ItemStack, Double> outputScaled = new IdentityHashMap<ItemStack, Double>(outputs.size());
                for (Map.Entry entry : outputs.entrySet()) {
                    outputScaled.put((ItemStack)entry.getKey(), (Double)entry.getValue() / (double)resultCount);
                }
                if (!outputs.isEmpty() || !missingSub.isEmpty()) {
                    Object in;
                    in = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
                    RecyclingCalculation recyclingCalculation = new RecyclingCalculation(recipe, (ItemStack)in, outputScaled);
                    if (!missingSub.isEmpty()) {
                        for (ItemStack s : missingSub.keySet()) {
                            recyclingCalculation.queriedSubcomponents.put(s, (double)((Integer)missingSub.get(s)).intValue() / (double)resultCount);
                        }
                    }
                    return recyclingCalculation;
                }
            }
            return null;
        }
    }

    private static class RecyclingCalculation {
        Recipe<?> recipe;
        ItemStack stack;
        Map<ItemStack, Double> outputs;
        Map<ItemStack, Double> queriedSubcomponents = new HashMap<ItemStack, Double>();

        public RecyclingCalculation(Recipe<?> recipe, ItemStack stack, Map<ItemStack, Double> outputs) {
            this.recipe = recipe;
            this.stack = stack;
            this.outputs = outputs;
        }

        public boolean isValid() {
            return !this.outputs.isEmpty() && this.queriedSubcomponents.isEmpty();
        }

        public boolean validateSubcomponent(RecyclingCalculation calc) {
            if (this.isValid()) {
                return true;
            }
            if (!calc.isValid()) {
                return false;
            }
            Iterator<ItemStack> it = this.queriedSubcomponents.keySet().iterator();
            while (it.hasNext()) {
                ItemStack next = it.next();
                if (!ItemStack.m_41746_((ItemStack)next, (ItemStack)calc.stack)) continue;
                double queriedAmount = this.queriedSubcomponents.get(next);
                for (Map.Entry<ItemStack, Double> e : calc.outputs.entrySet()) {
                    double scaledVal = e.getValue() * queriedAmount;
                    boolean b = true;
                    for (ItemStack key : this.outputs.keySet()) {
                        if (!ItemStack.m_41746_((ItemStack)key, (ItemStack)e.getKey())) continue;
                        this.outputs.put(key, this.outputs.get(key) + scaledVal);
                        b = false;
                        break;
                    }
                    if (!b) continue;
                    this.outputs.put(e.getKey(), scaledVal);
                }
                it.remove();
            }
            return this.isValid();
        }
    }
}

