/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasinConfig;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import org.cyclops.integrateddynamicscompat.modcompat.jei.JEIIntegratedDynamicsConfig;
import org.cyclops.integrateddynamicscompat.modcompat.jei.mechanicalsqueezer.MechanicalSqueezerRecipeJEI;

public class MechanicalSqueezerRecipeCategory
implements IRecipeCategory<MechanicalSqueezerRecipeJEI> {
    public static final RecipeType<MechanicalSqueezerRecipeJEI> TYPE = RecipeType.create((String)"integrateddynamicscompat", (String)"mechanical_squeezer", MechanicalSqueezerRecipeJEI.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrowDrawable;

    public MechanicalSqueezerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("integrateddynamicscompat", "textures/gui/mechanical_squeezer_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 116, 53);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_MECHANICAL_SQUEEZER));
        this.arrowDrawable = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(resourceLocation, 116, 0, 4, 11), 20, IDrawableAnimated.StartDirection.TOP, false);
    }

    public RecipeType<MechanicalSqueezerRecipeJEI> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)RegistryEntries.BLOCK_MECHANICAL_SQUEEZER.m_7705_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MechanicalSqueezerRecipeJEI recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 18).addItemStacks(recipe.getInputItem());
        int offset = 0;
        for (int i = 0; i < recipe.getOutputItems().size(); ++i) {
            RecipeSqueezer.IngredientChance outputItem = (RecipeSqueezer.IngredientChance)recipe.getOutputItems().get(i);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 76 + (i % 2 > 0 ? 22 : 0), 8 + offset + (i > 1 ? 22 : 0)).addItemStack(outputItem.getIngredientFirst())).addTooltipCallback((view, tooltip) -> {
                float chance = outputItem.getChance();
                tooltip.add(Component.m_237113_((String)("Chance: " + chance * 100.0f + "%")).m_130940_(ChatFormatting.GRAY));
            });
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 30).setFluidRenderer(1000L, true, 16, 16).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluid());
    }

    public void draw(MechanicalSqueezerRecipeJEI recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        this.arrowDrawable.draw(matrixStack, 45, 21);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        MutableComponent energy = JEIIntegratedDynamicsConfig.getEnergyTextComponent(recipe.getDuration(), BlockMechanicalDryingBasinConfig.consumptionRate);
        fontRenderer.m_92889_(matrixStack, (Component)energy, (float)((this.background.getWidth() - fontRenderer.m_92852_((FormattedText)energy)) / 2 - 10), 0.0f, -8355712);
        MutableComponent duration = JEIIntegratedDynamicsConfig.getDurationSecondsTextComponent(recipe.getDuration());
        fontRenderer.m_92889_(matrixStack, (Component)duration, (float)((this.background.getWidth() - fontRenderer.m_92852_((FormattedText)duration)) / 2 - 10), 42.0f, -8355712);
    }
}

