/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.screen.text;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.moddingx.libx.screen.text.AlignedComponent;

public class TextScreenContent {
    private final Font font;
    private final List<PlacedText> lines;
    private final int width;
    private final int height;

    public TextScreenContent(Font font, int width, List<AlignedComponent> components) {
        ImmutableList.Builder list = ImmutableList.builder();
        int height = 0;
        for (AlignedComponent component : components) {
            List<FormattedCharSequence> lines = component.wrap() ? ComponentRenderUtils.m_94005_((FormattedText)component.text(), (int)width, (Font)font) : List.of(Language.m_128107_().m_5536_((FormattedText)component.text()));
            boolean first = true;
            for (FormattedCharSequence line : lines) {
                if (first) {
                    height += component.top();
                    first = false;
                } else {
                    height += 2;
                }
                list.add((Object)new PlacedText(line, component.left(), height, 0xFFFFFF & component.color(), component.shadow()));
                Objects.requireNonNull(font);
                height += 9;
            }
        }
        this.font = font;
        this.lines = list.build();
        this.width = width;
        this.height = height;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public void render(PoseStack poseStack, int left, int top) {
        for (PlacedText line : this.lines) {
            if (line.shadow()) {
                this.font.m_92744_(poseStack, line.text(), (float)(left + line.x()), (float)(top + line.y()), line.color());
                continue;
            }
            this.font.m_92877_(poseStack, line.text(), (float)(left + line.x()), (float)(top + line.y()), line.color());
        }
    }

    @Nullable
    public Style hoveredStyle(int mouseX, int mouseY) {
        for (PlacedText line : this.lines) {
            if (mouseX < line.x() || mouseX > line.x() + this.font.m_92724_(line.text()) || mouseY < line.y()) continue;
            int n = line.y();
            Objects.requireNonNull(this.font);
            if (mouseY > n + 9) continue;
            int relX = mouseX - line.x();
            Style style = this.font.m_92865_().m_92338_(line.text(), relX);
            if (style == null) continue;
            return style;
        }
        return null;
    }

    private record PlacedText(FormattedCharSequence text, int x, int y, int color, boolean shadow) {
    }
}

