/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kotori316.limiter.LimitMobSpawn;
import com.kotori316.limiter.TestSpawn;
import com.kotori316.limiter.capability.LMSDataPackHolder;
import com.kotori316.limiter.capability.LMSHandler;
import com.kotori316.limiter.capability.RuleType;
import com.kotori316.limiter.conditions.All;
import com.kotori316.limiter.conditions.And;
import com.kotori316.limiter.conditions.BiomeLimit;
import com.kotori316.limiter.conditions.DimensionLimit;
import com.kotori316.limiter.conditions.EntityLimit;
import com.kotori316.limiter.conditions.LightLevelLimit;
import com.kotori316.limiter.conditions.MobCategoryLimit;
import com.kotori316.limiter.conditions.MobSpawnTypeLimit;
import com.kotori316.limiter.conditions.Not;
import com.kotori316.limiter.conditions.Or;
import com.kotori316.limiter.conditions.PositionLimit;
import com.kotori316.limiter.conditions.RandomLimit;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.VisibleForTesting;

public class SpawnConditionLoader
extends SimpleJsonResourceReloadListener {
    private static final Marker MARKER = MarkerManager.getMarker((String)"SpawnConditionLoader");
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Map<String, TestSpawn.Serializer<?>> serializers = new HashMap();
    public static final SpawnConditionLoader INSTANCE = new SpawnConditionLoader();
    private final LMSDataPackHolder holder = new LMSDataPackHolder();
    @VisibleForTesting
    static boolean SKIP_CONDITION = System.getProperty("limit_mob_spawn_data_gen") != null;

    private SpawnConditionLoader() {
        super(GSON, "limitmobspawn");
        this.register(TestSpawn.EMPTY_SERIALIZER);
        this.register(All.SERIALIZER);
        this.register(And.SERIALIZER);
        this.register(Or.SERIALIZER);
        this.register(Not.SERIALIZER);
        this.register(DimensionLimit.SERIALIZER);
        this.register(EntityLimit.SERIALIZER);
        this.register(MobCategoryLimit.SERIALIZER);
        this.register(PositionLimit.SERIALIZER);
        this.register(MobSpawnTypeLimit.SERIALIZER);
        this.register(BiomeLimit.SERIALIZER);
        this.register(RandomLimit.SERIALIZER);
        this.register(LightLevelLimit.SERIALIZER);
    }

    public void register(TestSpawn.Serializer<?> serializer) {
        TestSpawn.Serializer<?> put = this.serializers.put(serializer.getType(), serializer);
        if (put != null) {
            throw new IllegalArgumentException(String.format("Duplicated keys: %s, TYPE: %s, Map: %s", serializer.getType(), serializer.getClass(), this.serializers));
        }
        LimitMobSpawn.LOGGER.debug(MARKER, "Registered a new serializer. {}", (Object)serializer.getClass().getName());
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        HashSet<TestSpawn> denySet = new HashSet<TestSpawn>();
        HashSet<TestSpawn> defaultSet = new HashSet<TestSpawn>();
        HashSet<TestSpawn> forceSet = new HashSet<TestSpawn>();
        for (JsonElement element : objectIn.values()) {
            ICondition.IContext context;
            JsonObject asObject = element.getAsJsonObject();
            if (this.holder.context != null) {
                context = this.holder.context;
            } else {
                if (!SKIP_CONDITION) {
                    LimitMobSpawn.LOGGER.warn(MARKER, "holder.context should not be null.");
                }
                context = ICondition.IContext.EMPTY;
            }
            if (!SKIP_CONDITION && !CraftingHelper.processConditions((JsonObject)asObject, (String)"conditions", (ICondition.IContext)context)) continue;
            defaultSet.addAll(this.getValues(asObject.get(RuleType.DEFAULT.saveName())));
            denySet.addAll(this.getValues(asObject.get(RuleType.DENY.saveName())));
            forceSet.addAll(this.getValues(asObject.get(RuleType.FORCE.saveName())));
        }
        this.holder.setDefaultSet(defaultSet);
        this.holder.setDenySet(denySet);
        this.holder.setForceSet(forceSet);
    }

    public LMSHandler getHolder() {
        return this.holder;
    }

    public void setContext(ICondition.IContext context) {
        this.holder.context = context;
    }

    @VisibleForTesting
    Set<TestSpawn> getValues(JsonElement element) {
        if (element == null) {
            return Collections.emptySet();
        }
        if (element.isJsonArray()) {
            return StreamSupport.stream(element.getAsJsonArray().spliterator(), false).map(JsonElement::getAsJsonObject).map(this::deserialize).collect(Collectors.toSet());
        }
        if (element.isJsonObject()) {
            if (GsonHelper.m_13900_((JsonObject)element.getAsJsonObject(), (String)"type")) {
                return Collections.singleton(this.deserialize(element.getAsJsonObject()));
            }
            return element.getAsJsonObject().entrySet().stream().map(Map.Entry::getValue).map(JsonElement::getAsJsonObject).map(this::deserialize).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public TestSpawn deserialize(JsonObject object) {
        return this.deserialize(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)object));
    }

    public <T> TestSpawn deserialize(Dynamic<T> dynamic) {
        String type = dynamic.get("type").asString("anonymous");
        TestSpawn.Serializer<?> serializer = this.serializers.get(type);
        if (serializer == null || serializer == TestSpawn.EMPTY_SERIALIZER) {
            if (SKIP_CONDITION) {
                throw new IllegalArgumentException("Type %s is not registered. Error in loading %s".formatted(type, dynamic.getValue()));
            }
            LimitMobSpawn.LOGGER.error(MARKER, "Type {} is not registered. Error in loading {}", (Object)type, dynamic.getValue());
            return TestSpawn.Empty.INSTANCE;
        }
        return serializer.from(dynamic);
    }

    public boolean hasSerializeKey(String key) {
        return this.serializers.containsKey(key);
    }

    public TestSpawn.Serializer<?> getSerializer(String key) {
        return this.serializers.get(key);
    }

    public Set<String> serializeKeySet() {
        HashSet inactive = Sets.newHashSet((Object[])new String[]{"anonymous"});
        return this.serializers.keySet().stream().filter(s -> !inactive.contains(s)).collect(Collectors.toSet());
    }

    @VisibleForTesting
    static SpawnConditionLoader createInstance() {
        return new SpawnConditionLoader();
    }
}

