/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.capability;

import com.kotori316.limiter.SpawnConditionLoader;
import com.kotori316.limiter.TestSpawn;
import com.kotori316.limiter.capability.MobNumberLimit;
import com.kotori316.limiter.capability.RuleType;
import com.kotori316.limiter.capability.SpawnerControl;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public interface LMSHandler
extends INBTSerializable<CompoundTag> {
    public void addDefaultCondition(TestSpawn var1);

    public void addDenyCondition(TestSpawn var1);

    public void addForceCondition(TestSpawn var1);

    public Set<TestSpawn> getDefaultConditions();

    public Set<TestSpawn> getDenyConditions();

    public Set<TestSpawn> getForceConditions();

    public void clearDefaultConditions();

    public void clearDenyConditions();

    public void clearForceConditions();

    public SpawnerControl getSpawnerControl();

    public MobNumberLimit getMobNumberLimit();

    default public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        Collector<Tag, ListTag, ListTag> arrayCollector = Collector.of(ListTag::new, AbstractList::add, (l1, l2) -> {
            l1.addAll((Collection)l2);
            return l1;
        }, Collector.Characteristics.IDENTITY_FINISH);
        for (RuleType ruleType : RuleType.values()) {
            nbt.m_128365_(ruleType.saveName(), (Tag)ruleType.getRules(this).stream().map(t -> (Tag)t.to(NbtOps.f_128958_)).collect(arrayCollector));
        }
        nbt.m_128365_("SpawnerControl", (Tag)this.getSpawnerControl().serializeNBT());
        nbt.m_128365_("MobNumberLimit", (Tag)this.getMobNumberLimit().serializeNBT());
        return nbt;
    }

    default public void deserializeNBT(CompoundTag nbt) {
        for (RuleType ruleType : RuleType.values()) {
            nbt.m_128437_(ruleType.saveName(), 10).stream().map(n -> new Dynamic((DynamicOps)NbtOps.f_128958_, n)).map(SpawnConditionLoader.INSTANCE::deserialize).forEach(t -> ruleType.add(this, (TestSpawn)t));
        }
        this.getSpawnerControl().deserializeNBT(nbt.m_128469_("SpawnerControl"));
        this.getMobNumberLimit().deserializeNBT(nbt.m_128469_("MobNumberLimit"));
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.register(LMSHandler.class);
    }

    public static Stream<TestSpawn> getCombinedDefault(LMSHandler h1, LazyOptional<LMSHandler> h2) {
        return Stream.concat(h1.getDefaultConditions().stream(), h2.map(LMSHandler::getDefaultConditions).stream().flatMap(Collection::stream));
    }

    public static Stream<TestSpawn> getCombinedDeny(LMSHandler h1, LazyOptional<LMSHandler> h2) {
        return Stream.concat(h1.getDenyConditions().stream(), h2.map(LMSHandler::getDenyConditions).stream().flatMap(Collection::stream));
    }

    public static Stream<TestSpawn> getCombinedForce(LMSHandler h1, LazyOptional<LMSHandler> h2) {
        return Stream.concat(h1.getForceConditions().stream(), h2.map(LMSHandler::getForceConditions).stream().flatMap(Collection::stream));
    }
}

