/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedValue;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.integration.gender.ToolsGenderCapabilityHelper;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.util.ToolsUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMekanismArmor
extends ArmorItem
implements IHasRepairType,
IAttributeRefresher {
    private final MaterialCreator material;
    private final AttributeCache attributeCache;

    public ItemMekanismArmor(MaterialCreator material, EquipmentSlot slot, Item.Properties properties) {
        super((ArmorMaterial)material, slot, properties);
        this.material = material;
        CachedIntValue armorConfig = switch (slot) {
            case EquipmentSlot.FEET -> material.bootArmor;
            case EquipmentSlot.LEGS -> material.leggingArmor;
            case EquipmentSlot.CHEST -> material.chestplateArmor;
            case EquipmentSlot.HEAD -> material.helmetArmor;
            default -> throw new IllegalArgumentException("Invalid slot type for armor");
        };
        this.attributeCache = new AttributeCache((IAttributeRefresher)this, new CachedValue[]{material.toughness, material.knockbackResistance, armorConfig});
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        ToolsUtils.addDurability(tooltip, stack);
    }

    @Override
    @NotNull
    public Ingredient getRepairMaterial() {
        return this.m_40401_().m_6230_();
    }

    public int m_40404_() {
        return this.m_40401_().m_7365_(this.m_40402_());
    }

    public float m_40405_() {
        return this.m_40401_().m_6651_();
    }

    public float getKnockbackResistance() {
        return this.m_40401_().m_6649_();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.m_7366_(this.m_40402_());
    }

    public boolean m_41465_() {
        return this.material.m_7366_(this.m_40402_()) > 0;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        return slot == this.m_40402_() ? (Multimap)this.attributeCache.get() : ImmutableMultimap.of();
    }

    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        UUID modifier = f_40380_[this.m_40402_().m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(modifier, "Armor modifier", (double)this.m_40404_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(modifier, "Armor toughness", (double)this.m_40405_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(modifier, "Armor knockback resistance", (double)this.getKnockbackResistance(), AttributeModifier.Operation.ADDITION));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        ItemCapabilityWrapper wrapper = new ItemCapabilityWrapper(stack, new ItemCapabilityWrapper.ItemCapability[0]);
        ToolsGenderCapabilityHelper.addGenderCapability(this, wrapper);
        return wrapper;
    }
}

