/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.network;

import mythicbotany.network.AlfSwordLeftClickMessage;
import mythicbotany.network.InfusionMessage;
import mythicbotany.network.MagnetImmunityMessage;
import mythicbotany.network.ParticleMessage;
import mythicbotany.network.PylonMessage;
import mythicbotany.network.UpdatePortalTimeMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.network.NetworkX;

public class MythicNetwork
extends NetworkX {
    public MythicNetwork(ModX mod) {
        super(mod);
    }

    protected NetworkX.Protocol getProtocol() {
        return NetworkX.Protocol.of((String)"7");
    }

    public void registerPackets() {
        this.registerGame(NetworkDirection.PLAY_TO_CLIENT, new ParticleMessage.Serializer(), () -> ParticleMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_CLIENT, new InfusionMessage.Serializer(), () -> InfusionMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_CLIENT, new PylonMessage.Serializer(), () -> PylonMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_CLIENT, new UpdatePortalTimeMessage.Serializer(), () -> UpdatePortalTimeMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_CLIENT, new MagnetImmunityMessage.Serializer(), () -> MagnetImmunityMessage.Handler::new);
        this.registerGame(NetworkDirection.PLAY_TO_SERVER, new AlfSwordLeftClickMessage.Serializer(), () -> AlfSwordLeftClickMessage.Handler::new);
    }

    public void spawnParticle(Level level, SimpleParticleType particle, int amount, double x, double y, double z, double xm, double ym, double zm, double xd, double yd, double zd) {
        this.spawnParticle(level, particle, amount, x, y, z, xm, ym, zm, xd, yd, zd, false);
    }

    public void spawnParticle(Level level, SimpleParticleType particle, int amount, double x, double y, double z, double xm, double ym, double zm, double xd, double yd, double zd, boolean randomizePosition) {
        if (level.f_46443_) {
            for (int i = 0; i < amount; ++i) {
                if (randomizePosition) {
                    level.m_7106_((ParticleOptions)particle, x + level.f_46441_.m_188500_() * 2.0 * xd - xd, y + level.f_46441_.m_188500_() * 2.0 * yd - yd, z + level.f_46441_.m_188500_() * 2.0 * zd - zd, xm, ym, zm);
                    continue;
                }
                level.m_7106_((ParticleOptions)particle, x, y, z, xm + level.f_46441_.m_188500_() * 2.0 * xd - xd, ym + level.f_46441_.m_188500_() * 2.0 * yd - yd, zm + level.f_46441_.m_188500_() * 2.0 * zd - zd);
            }
        } else {
            ResourceLocation id = ForgeRegistries.PARTICLE_TYPES.getKey((Object)particle);
            if (id == null) {
                return;
            }
            this.channel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, 100.0, level.m_46472_())), (Object)new ParticleMessage(id, x, y, z, amount, xm, ym, zm, xd, yd, zd, randomizePosition));
        }
    }

    public void spawnInfusionParticles(Level level, BlockPos pos, double progress, int fromColor, int toColor) {
        if (!level.f_46443_) {
            this.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)new InfusionMessage(pos, progress, fromColor, toColor));
        }
    }

    public void updatePortalTime(ServerPlayer player, int portalTime) {
        if (!player.m_20193_().f_46443_) {
            this.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdatePortalTimeMessage(portalTime));
        }
    }

    public void setItemMagnetImmune(ItemEntity ie) {
        if (!ie.f_19853_.f_46443_ && !ie.getPersistentData().m_128471_("PreventRemoteMovement")) {
            ie.getPersistentData().m_128379_("PreventRemoteMovement", true);
            this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> ie), (Object)new MagnetImmunityMessage(ie.m_19879_(), true, ie.m_20185_(), ie.m_20186_(), ie.m_20189_()));
        }
    }

    public void removeItemMagnetImmune(ItemEntity ie) {
        if (!ie.f_19853_.f_46443_ && ie.getPersistentData().m_128471_("PreventRemoteMovement")) {
            ie.getPersistentData().m_128379_("PreventRemoteMovement", false);
            this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> ie), (Object)new MagnetImmunityMessage(ie.m_19879_(), false, ie.m_20185_(), ie.m_20186_(), ie.m_20189_()));
        }
    }
}

