/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockAncientLeaves;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;

public class BlockGoldenLeaves
extends LeavesBlock
implements IModItem,
IColorProvidingBlock,
IColorProvidingItem,
ICustomBlockState {
    public static final int HIGHEST_STAGE = 3;
    public static final IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)0, (int)3);

    public BlockGoldenLeaves() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76274_, (MaterialColor)MaterialColor.f_76366_).m_60978_(0.2f).m_60977_().m_60955_().m_60918_(SoundType.f_56740_));
        ModRegistry.ALL_ITEMS.add(this);
    }

    public static boolean convert(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof LeavesBlock && !(state.m_60734_() instanceof BlockAncientLeaves) && !(state.m_60734_() instanceof BlockGoldenLeaves)) {
            if (!level.f_46443_) {
                level.m_46597_(pos, (BlockState)((BlockState)ModBlocks.GOLDEN_LEAVES.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)(state.m_61138_((Property)LeavesBlock.f_54418_) ? (Integer)state.m_61143_((Property)LeavesBlock.f_54418_) : Integer.valueOf(1)))).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)(state.m_61138_((Property)LeavesBlock.f_54419_) ? (Boolean)state.m_61143_((Property)LeavesBlock.f_54419_) : Boolean.valueOf(false))));
            }
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "golden_leaves";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level levelIn, BlockPos pos, RandomSource rand) {
        if ((Integer)stateIn.m_61143_((Property)STAGE) == 3 && rand.m_188501_() >= 0.75f) {
            NaturesAuraAPI.instance().spawnMagicParticle((float)pos.m_123341_() + rand.m_188501_(), (float)pos.m_123342_() + rand.m_188501_(), (float)pos.m_123343_() + rand.m_188501_(), 0.0, 0.0, 0.0, 0xF2FF00, 0.5f + rand.m_188501_(), 50, 0.0f, false, true);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STAGE});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockColor getBlockColor() {
        return (state, levelIn, pos, tintIndex) -> {
            int color = 0xF2FF00;
            if (state != null && levelIn != null && pos != null) {
                int foliage = BiomeColors.m_108804_((BlockAndTintGetter)levelIn, (BlockPos)pos);
                return Helper.blendColors(color, foliage, (float)((Integer)state.m_61143_((Property)STAGE)).intValue() / 3.0f);
            }
            return color;
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        return (stack, tintIndex) -> 0xF2FF00;
    }

    public void m_213898_(BlockState state, ServerLevel levelIn, BlockPos pos, RandomSource random) {
        super.m_213898_(state, levelIn, pos, random);
        if (!levelIn.f_46443_) {
            BlockPos offset;
            int stage = (Integer)state.m_61143_((Property)STAGE);
            if (stage < 3) {
                levelIn.m_46597_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)));
            }
            if (stage > 1 && levelIn.m_46749_(offset = pos.m_121945_(Direction.m_235672_((RandomSource)random)))) {
                BlockGoldenLeaves.convert((Level)levelIn, offset);
            }
        }
    }

    public boolean m_6724_(BlockState p_54449_) {
        return true;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }
}

