/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlockEntityPotionGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    public BlockEntityPotionGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.POTION_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 10L == 0L && Multiblocks.POTION_GENERATOR.isComplete(this.f_58857_, this.f_58858_)) {
            boolean addedOne = false;
            List clouds = this.f_58857_.m_45976_(AreaEffectCloud.class, new AABB(this.f_58858_).m_82400_(2.0));
            for (AreaEffectCloud cloud : clouds) {
                float newRadius;
                if (!cloud.m_6084_()) continue;
                if (!addedOne) {
                    Potion type = cloud.m_146791_();
                    if (type == null) continue;
                    for (MobEffectInstance effect : type.m_43488_()) {
                        MobEffect potion = effect.m_19544_();
                        if (!potion.m_19486_() || potion.m_8093_()) continue;
                        int toAdd = (effect.m_19564_() * 7 + 1) * (effect.m_19557_() / 25) * 100;
                        boolean canGen = this.canGenerateRightNow(toAdd);
                        if (canGen) {
                            this.generateAura(toAdd);
                        }
                        PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.POTION_GEN, PotionUtils.m_43559_((Potion)type), canGen ? 1 : 0));
                        addedOne = true;
                        break;
                    }
                }
                if ((newRadius = cloud.m_19743_() - 0.25f) < 0.5f) {
                    cloud.m_6074_();
                    continue;
                }
                cloud.m_19712_(newRadius);
            }
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }
}

