/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.serialization.jankson.JanksonJsonOps;
import corgitaco.corgilib.serialization.jankson.JanksonUtil;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import potionstudios.byg.BYG;
import potionstudios.byg.config.BYGConfigHandler;
import potionstudios.byg.util.ModPlatform;

public record BiomepediaInventoryConfig(boolean visible, PlayerInventoryPosition settings) {
    public static boolean server_value = true;
    public static final Codec<BiomepediaInventoryConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("visible").forGetter(BiomepediaInventoryConfig::visible), (App)PlayerInventoryPosition.CODEC.fieldOf("inventory_position").forGetter(BiomepediaInventoryConfig::settings)).apply((Applicative)builder, BiomepediaInventoryConfig::new));
    public static final BiomepediaInventoryConfig DEFAULT = new BiomepediaInventoryConfig(true, new PlayerInventoryPosition(126, 22));
    public static BiomepediaInventoryConfig INSTANCE = null;

    public static BiomepediaInventoryConfig getConfig() {
        return BiomepediaInventoryConfig.getConfig(false, false);
    }

    public static BiomepediaInventoryConfig getConfig(boolean serialize) {
        return BiomepediaInventoryConfig.getConfig(serialize, false);
    }

    public static BiomepediaInventoryConfig getConfig(boolean serialize, boolean recreate) {
        if (INSTANCE == null || serialize || recreate) {
            INSTANCE = BiomepediaInventoryConfig.readConfig(recreate);
        }
        return INSTANCE;
    }

    private static BiomepediaInventoryConfig readConfig(boolean recreate) {
        Path path = ModPlatform.INSTANCE.configPath().resolve("client").resolve("biomepedia_inventory.json5");
        if (!path.toFile().exists() || recreate) {
            JanksonUtil.createConfig((Path)path, CODEC, (String)"/*\nThis file uses the \".json5\" file extension which allows for comments like this in a json file!\nYour text editor may show this file with invalid/no syntax, if so, we recommend you download:\n\nVSCode: https://code.visualstudio.com/\nJSON5 plugin(for VSCode): https://marketplace.visualstudio.com/items?itemName=mrmlnc.vscode-json5\n\nto make editing this file much easier.\n*/", (Map)((Map)Util.m_137469_(new HashMap(), map -> {
                map.put("visible", "Whether the biomepedia button is visible in the player inventory.\nServers can disable this button from functioning regardless of this value.");
                map.put("inventory_position", "Inventory GUI settings for the biomepedia button position.");
            })), (DynamicOps)JanksonJsonOps.INSTANCE, (Object)DEFAULT);
        }
        BYG.logDebug(String.format("\"%s\" was read.", path.toString()));
        try {
            return (BiomepediaInventoryConfig)JanksonUtil.readConfig((Path)path, CODEC, (DynamicOps)JanksonJsonOps.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
            BYGConfigHandler.CONFIG_EXCEPTIONS.add(e);
            return DEFAULT;
        }
    }

    public record PlayerInventoryPosition(int widthOffset, int heightOffset) {
        public static final Codec<PlayerInventoryPosition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("width_offset").forGetter(PlayerInventoryPosition::widthOffset), (App)Codec.INT.fieldOf("height_offset").forGetter(PlayerInventoryPosition::heightOffset)).apply((Applicative)builder, PlayerInventoryPosition::new));
    }
}

